/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.gui;

import com.cburch.draw.toolbar.AbstractToolbarModel;
import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.logisim.gui.icons.HdlIcon;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.base.HdlModelListener;
import com.cburch.logisim.vhdl.gui.HdlContentView;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class HdlToolbarModel
extends AbstractToolbarModel
implements HdlModelListener {
    private final HdlContentView editor;
    private final List<ToolbarItem> items;
    final HdlToolbarItem hdlImport;
    final HdlToolbarItem hdlExport;
    final HdlToolbarItem hdlValidate;
    public static final String HDL_IMPORT = "hdlImport";
    public static final String HDL_EXPORT = "hdlEmport";
    public static final String HDL_VALIDATE = "hdlValidate";
    boolean validateEnabled = false;

    public HdlToolbarModel(Project proj, HdlContentView editor) {
        this.editor = editor;
        ArrayList<HdlToolbarItem> rawItems = new ArrayList<HdlToolbarItem>();
        this.hdlImport = new HdlToolbarItem(new HdlIcon(HDL_IMPORT), HDL_IMPORT, Strings.S.getter("hdlOpenButton"));
        this.hdlExport = new HdlToolbarItem(new HdlIcon(HDL_EXPORT), HDL_EXPORT, Strings.S.getter("hdlSaveButton"));
        this.hdlValidate = new HdlToolbarItem(new HdlIcon(HDL_VALIDATE), HDL_VALIDATE, Strings.S.getter("validateButton"));
        rawItems.add(this.hdlImport);
        rawItems.add(this.hdlExport);
        rawItems.add(this.hdlValidate);
        this.items = Collections.unmodifiableList(rawItems);
    }

    @Override
    public List<ToolbarItem> getItems() {
        return this.items;
    }

    @Override
    public boolean isSelected(ToolbarItem item) {
        return false;
    }

    @Override
    public void itemSelected(ToolbarItem item) {
        this.doAction(((HdlToolbarItem)item).action);
    }

    void doAction(String action) {
        switch (action) {
            case "hdlImport": {
                this.editor.doImport();
                break;
            }
            case "hdlEmport": {
                this.editor.doExport();
                break;
            }
            case "hdlValidate": {
                this.editor.doValidate();
                break;
            }
        }
    }

    boolean isEnabled(String action) {
        return action.equals(HDL_VALIDATE) ? this.validateEnabled : true;
    }

    void setDirty(boolean dirty) {
        if (this.validateEnabled != dirty) {
            this.validateEnabled = dirty;
            this.fireToolbarContentsChanged();
        }
    }

    @Override
    public void contentSet(HdlModel source) {
        if (this.validateEnabled) {
            this.validateEnabled = false;
            this.fireToolbarContentsChanged();
        }
    }

    @Override
    public void aboutToSave(HdlModel source) {
    }

    @Override
    public void displayChanged(HdlModel source) {
    }

    @Override
    public void appearanceChanged(HdlModel source) {
    }

    private class HdlToolbarItem
    implements ToolbarItem {
        final Icon icon;
        final String action;
        final StringGetter toolTip;

        public HdlToolbarItem(Icon icon, String action, StringGetter toolTip) {
            this.icon = icon;
            this.action = action;
            this.toolTip = toolTip;
        }

        @Override
        public Dimension getDimension(Object orientation) {
            int w = 16;
            int h = 16;
            if (this.icon != null) {
                w = this.icon.getIconWidth();
                h = this.icon.getIconHeight() + 2;
            }
            return new Dimension(w, h);
        }

        @Override
        public String getToolTip() {
            return this.toolTip == null ? null : this.toolTip.toString();
        }

        @Override
        public boolean isSelectable() {
            return HdlToolbarModel.this.isEnabled(this.action);
        }

        @Override
        public void paintIcon(Component destination, Graphics gfx) {
            if (!this.isSelectable() && gfx instanceof Graphics2D) {
                ((Graphics2D)gfx).setComposite(AlphaComposite.getInstance(3, 0.3f));
            }
            if (this.icon == null) {
                gfx.setColor(new Color(255, 128, 128));
                gfx.fillRect(4, 4, 8, 8);
                gfx.setColor(Color.BLACK);
                gfx.drawLine(4, 4, 12, 12);
                gfx.drawLine(4, 12, 12, 4);
                gfx.drawRect(4, 4, 8, 8);
            } else {
                this.icon.paintIcon(destination, gfx, 0, 1);
            }
        }
    }
}

