/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.PlexerIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.plexers.MultiplexerHdlGeneratorFactory;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Multiplexer
extends InstanceFactory {
    public static final String _ID = "Multiplexer";

    static void drawSelectCircle(Graphics g, Bounds bds, Location loc) {
        Location circLoc;
        int locDelta;
        if (Math.min(bds.getHeight(), bds.getWidth()) <= 20) {
            return;
        }
        int n = locDelta = Math.max(bds.getHeight(), bds.getWidth()) <= 50 ? 8 : 6;
        if (bds.getHeight() >= bds.getWidth()) {
            circLoc = loc.getY() < bds.getY() + bds.getHeight() / 2 ? loc.translate(0, locDelta) : loc.translate(0, -locDelta);
            if (loc.getX() >= bds.getX() + bds.getWidth()) {
                loc.translate(-4, 0);
            } else if (loc.getX() <= bds.getX()) {
                loc.translate(4, 0);
            }
        } else {
            circLoc = loc.getX() < bds.getX() + bds.getWidth() / 2 ? loc.translate(locDelta, 0) : loc.translate(-locDelta, 0);
            if (loc.getY() >= bds.getY() + bds.getHeight()) {
                loc.translate(0, -4);
            } else if (loc.getY() <= bds.getY()) {
                loc.translate(0, 4);
            }
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillOval(circLoc.getX() - 3, circLoc.getY() - 3, 6, 6);
    }

    public Multiplexer() {
        super(_ID, Strings.S.getter("multiplexerComponent"), new MultiplexerHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.FACING, PlexersLibrary.ATTR_SIZE, StdAttr.SELECT_LOC, PlexersLibrary.ATTR_SELECT, StdAttr.WIDTH, PlexersLibrary.ATTR_DISABLED, PlexersLibrary.ATTR_ENABLE}, new Object[]{Direction.EAST, PlexersLibrary.SIZE_WIDE, StdAttr.SELECT_BOTTOM_LEFT, PlexersLibrary.DEFAULT_SELECT, BitWidth.ONE, PlexersLibrary.DISABLED_ZERO, PlexersLibrary.DEFAULT_ENABLE});
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(PlexersLibrary.ATTR_SELECT, 1, 5, 0), new BitWidthConfigurator(StdAttr.WIDTH)));
        this.setIcon(new PlexerIcon(false, false));
        this.setFacingAttribute(StdAttr.FACING);
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        if (attr == PlexersLibrary.ATTR_ENABLE) {
            return ver.compareTo(new LogisimVersion(3, 6, 1)) <= 0;
        }
        return super.getDefaultAttributeValue(attr, ver);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder completeName = new StringBuilder();
        completeName.append(CorrectLabel.getCorrectLabel(this.getName()));
        if (attrs.getValue(StdAttr.WIDTH).getWidth() > 1) {
            completeName.append("_bus");
        }
        completeName.append("_").append(1 << attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth());
        return completeName.toString();
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        AttributeOption size = attrs.getValue(PlexersLibrary.ATTR_SIZE);
        boolean wide = size == PlexersLibrary.SIZE_WIDE;
        Direction dir = attrs.getValue(StdAttr.FACING);
        BitWidth select = attrs.getValue(PlexersLibrary.ATTR_SELECT);
        int inputs = 1 << select.getWidth();
        if (inputs == 2) {
            int w = wide ? 30 : 20;
            return Bounds.create(-w, -20, w, 40).rotate(Direction.EAST, dir, 0, 0);
        }
        int w = wide ? 40 : 20;
        int lengthAdjust = wide ? 0 : -5;
        int offs = -(inputs / 2) * 10 - 10;
        int length = inputs * 10 + 20 + lengthAdjust;
        if (!(wide || dir != Direction.SOUTH && dir != Direction.WEST)) {
            offs += 5;
        }
        return Bounds.create(-w, offs, w, length).rotate(Direction.EAST, dir, 0, 0);
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        return attrs.getValue(PlexersLibrary.ATTR_DISABLED) == PlexersLibrary.DISABLED_FLOATING;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == StdAttr.SELECT_LOC || attr == PlexersLibrary.ATTR_SELECT || attr == PlexersLibrary.ATTR_SIZE) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == StdAttr.WIDTH || attr == PlexersLibrary.ATTR_ENABLE) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == PlexersLibrary.ATTR_DISABLED) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        AttributeOption size = painter.getAttributeValue(PlexersLibrary.ATTR_SIZE);
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        BitWidth select = painter.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Bounds bds = painter.getBounds();
        int lean = select.getWidth() == 1 ? (size == PlexersLibrary.SIZE_NARROW ? 7 : 10) : (size == PlexersLibrary.SIZE_NARROW ? 10 : 20);
        PlexersLibrary.drawTrapezoid(painter.getGraphics(), bds, facing, lean);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int halign;
        int y0;
        int x0;
        int len;
        int dy;
        int dx;
        boolean oddside;
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        AttributeOption size = painter.getAttributeValue(PlexersLibrary.ATTR_SIZE);
        boolean wide = size == PlexersLibrary.SIZE_WIDE;
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        BitWidth select = painter.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean enable = painter.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int inputs = 1 << select.getWidth();
        GraphicsUtil.switchToWidth(g, 3);
        boolean vertical = facing != Direction.NORTH && facing != Direction.SOUTH;
        AttributeOption selectLoc = painter.getAttributeValue(StdAttr.SELECT_LOC);
        int selMult = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? 1 : -1;
        boolean bl = oddside = vertical == selMult < 0;
        if (wide) {
            dx = vertical ? 0 : -2 * selMult;
            dy = vertical ? 2 * selMult : 0;
        } else if (vertical) {
            dx = facing == Direction.EAST ? 1 : -1;
            dy = 2 * selMult;
        } else {
            dx = -2 * selMult;
            int n = dy = facing == Direction.SOUTH ? 1 : -1;
        }
        if (inputs == 2 || !wide && oddside) {
            Location pt = painter.getInstance().getPortLocation(inputs);
            if (painter.getShowState()) {
                g.setColor(painter.getPortValue(inputs).getColor());
            }
            len = wide ? 2 : 1;
            g.drawLine(pt.getX() - len * dx, pt.getY() - len * dy, pt.getX(), pt.getY());
        }
        if (enable.booleanValue()) {
            Location en = painter.getInstance().getPortLocation(inputs + 1);
            if (painter.getShowState()) {
                g.setColor(painter.getPortValue(inputs + 1).getColor());
            }
            len = inputs == 2 ? 3 : (wide ? 2 : (oddside ? 4 : 2));
            g.drawLine(en.getX() - len * dx, en.getY() - len * dy, en.getX(), en.getY());
        }
        GraphicsUtil.switchToWidth(g, 1);
        Multiplexer.drawSelectCircle(g, bds, painter.getInstance().getPortLocation(inputs));
        if (facing == Direction.WEST) {
            x0 = bds.getX() + bds.getWidth() - 3;
            y0 = bds.getY() + 15;
            halign = 1;
        } else if (facing == Direction.NORTH) {
            x0 = bds.getX() + 10;
            y0 = bds.getY() + bds.getHeight() - 2;
            halign = 0;
        } else if (facing == Direction.SOUTH) {
            x0 = bds.getX() + 10;
            y0 = bds.getY() + 12;
            halign = 0;
        } else {
            x0 = bds.getX() + 3;
            y0 = bds.getY() + 15;
            halign = -1;
        }
        g.setColor(Color.GRAY);
        GraphicsUtil.drawText(g, "0", x0, y0, halign, 1);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        int lean = inputs == 2 ? (size == PlexersLibrary.SIZE_NARROW ? 7 : 10) : (size == PlexersLibrary.SIZE_NARROW ? 10 : 20);
        PlexersLibrary.drawTrapezoid(g, bds, facing, lean);
        if (size == PlexersLibrary.SIZE_WIDE) {
            GraphicsUtil.drawCenteredText(g, "MUX", bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        }
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value out;
        Value en;
        BitWidth data = state.getAttributeValue(StdAttr.WIDTH);
        BitWidth select = state.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean enable = state.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int inputs = 1 << select.getWidth();
        Value value = en = enable != false ? state.getPortValue(inputs + 1) : Value.TRUE;
        if (en == Value.FALSE) {
            AttributeOption opt = state.getAttributeValue(PlexersLibrary.ATTR_DISABLED);
            Value base = opt == PlexersLibrary.DISABLED_ZERO ? Value.FALSE : Value.UNKNOWN;
            out = Value.repeat(base, data.getWidth());
        } else {
            Value sel;
            out = en == Value.ERROR && state.isPortConnected(inputs + 1) ? Value.createError(data) : ((sel = state.getPortValue(inputs)).isFullyDefined() ? state.getPortValue((int)sel.toLongValue()) : (sel.isErrorValue() ? Value.createError(data) : Value.createUnknown(data)));
        }
        state.setPort(inputs + (enable != false ? 2 : 1), out, 3);
    }

    private void updatePorts(Instance instance) {
        Location sel;
        AttributeOption size = instance.getAttributeValue(PlexersLibrary.ATTR_SIZE);
        boolean wide = size == PlexersLibrary.SIZE_WIDE;
        Direction dir = instance.getAttributeValue(StdAttr.FACING);
        boolean vertical = dir != Direction.NORTH && dir != Direction.SOUTH;
        AttributeOption selectLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        boolean botLeft = selectLoc == StdAttr.SELECT_BOTTOM_LEFT;
        int selMult = botLeft ? 1 : -1;
        BitWidth data = instance.getAttributeValue(StdAttr.WIDTH);
        BitWidth select = instance.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean enable = instance.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int inputs = 1 << select.getWidth();
        Port[] ps = new Port[inputs + (enable != false ? 3 : 2)];
        if (inputs == 2) {
            Location end1;
            Location end0;
            w = size == PlexersLibrary.SIZE_NARROW ? 20 : 30;
            int n = s = size == PlexersLibrary.SIZE_NARROW ? 10 : 20;
            if (dir == Direction.WEST) {
                end0 = Location.create(w, -10, true);
                end1 = Location.create(w, 10, true);
                sel = Location.create(s, selMult * 20, true);
            } else if (dir == Direction.NORTH) {
                end0 = Location.create(-10, w, true);
                end1 = Location.create(10, w, true);
                sel = Location.create(selMult * -20, s, true);
            } else if (dir == Direction.SOUTH) {
                end0 = Location.create(-10, -w, true);
                end1 = Location.create(10, -w, true);
                sel = Location.create(selMult * -20, -s, true);
            } else {
                end0 = Location.create(-w, -10, true);
                end1 = Location.create(-w, 10, true);
                sel = Location.create(-s, selMult * 20, true);
            }
            ps[0] = new Port(end0.getX(), end0.getY(), "input", data.getWidth());
            ps[1] = new Port(end1.getX(), end1.getY(), "input", data.getWidth());
        } else {
            w = size == PlexersLibrary.SIZE_NARROW ? 20 : 40;
            s = size == PlexersLibrary.SIZE_NARROW ? 10 : 20;
            int dx = -(inputs / 2) * 10;
            int ddx = 10;
            int dy = -(inputs / 2) * 10;
            int ddy = 10;
            if (dir == Direction.WEST) {
                dx = w;
                ddx = 0;
                sel = Location.create(s, selMult * (dy + 10 * inputs), true);
            } else if (dir == Direction.NORTH) {
                dy = w;
                ddy = 0;
                sel = Location.create(selMult * dx, s, true);
            } else if (dir == Direction.SOUTH) {
                dy = -w;
                ddy = 0;
                sel = Location.create(selMult * dx, -s, true);
            } else {
                dx = -w;
                ddx = 0;
                sel = Location.create(-s, selMult * (dy + 10 * inputs), true);
            }
            for (int i = 0; i < inputs; ++i) {
                ps[i] = new Port(dx, dy, "input", data.getWidth());
                dx += ddx;
                dy += ddy;
            }
        }
        if (!wide && !vertical && botLeft && inputs > 2) {
            sel = sel.translate(-10, 0);
        } else if (!wide && vertical && !botLeft && inputs > 2) {
            sel = sel.translate(0, -10);
        }
        Location en = sel.translate(dir, 10);
        ps[inputs] = new Port(sel.getX(), sel.getY(), "input", select.getWidth());
        if (enable.booleanValue()) {
            ps[inputs + 1] = new Port(en.getX(), en.getY(), "input", BitWidth.ONE);
        }
        ps[ps.length - 1] = new Port(0, 0, "output", data.getWidth());
        for (int i = 0; i < inputs; ++i) {
            ps[i].setToolTip(Strings.S.getter("multiplexerInTip", "" + i));
        }
        ps[inputs].setToolTip(Strings.S.getter("multiplexerSelectTip"));
        if (enable.booleanValue()) {
            ps[inputs + 1].setToolTip(Strings.S.getter("multiplexerEnableTip"));
        }
        ps[ps.length - 1].setToolTip(Strings.S.getter("multiplexerOutTip"));
        instance.setPorts(ps);
    }
}

