/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.memory.MemContentsSub;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.util.Arrays;

public class MemContents
implements Cloneable,
HexModel {
    private static final int PAGE_SIZE_BITS = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private EventSourceWeakSupport<HexModelListener> listeners = null;
    private int width;
    private int addrBits;
    private long mask;
    private Page[] pages;
    private boolean randomize;

    public static MemContents create(int addrBits, int width, boolean randomize) {
        return new MemContents(addrBits, width, randomize);
    }

    private MemContents(int addrBits, int width, boolean randomize) {
        this.setDimensions(addrBits, width);
        this.randomize = randomize;
    }

    @Override
    public void addHexModelListener(HexModelListener l) {
        if (this.listeners == null) {
            this.listeners = new EventSourceWeakSupport();
        }
        this.listeners.add(l);
    }

    public void clear() {
        for (int i = 0; i < this.pages.length; ++i) {
            if (this.pages[i] == null) continue;
            this.clearPage(i);
        }
    }

    public void condClear() {
        if (!AppPreferences.Memory_Startup_Unknown.getBoolean()) {
            this.clear();
        } else {
            for (int i = 0; i < this.pages.length; ++i) {
                long[] oldValues = this.pages[i] != null ? this.pages[i].get(0L, this.pages[i].getLength()) : null;
                this.pages[i] = MemContentsSub.createPage(4096, this.width, this.randomize);
                if (oldValues != null) {
                    this.fireBytesChanged(i << 12, oldValues.length, oldValues);
                    continue;
                }
                this.fireBytesChanged(i << 12, this.pages[i].getLength(), this.pages[i].get(0L, this.pages[i].getLength()));
            }
        }
    }

    private void clearPage(int index) {
        Page page = this.pages[index];
        long[] oldValues = new long[page.getLength()];
        boolean changed = false;
        for (int j = 0; j < oldValues.length; ++j) {
            long val;
            oldValues[j] = val = page.get(j) & this.mask;
            if (val == 0L) continue;
            changed = true;
        }
        if (changed) {
            this.pages[index] = null;
            this.fireBytesChanged(index << 12, oldValues.length, oldValues);
        }
    }

    public MemContents clone() {
        try {
            MemContents ret = (MemContents)super.clone();
            ret.listeners = null;
            ret.pages = new Page[this.pages.length];
            for (int i = 0; i < ret.pages.length; ++i) {
                if (this.pages[i] == null) continue;
                ret.pages[i] = this.pages[i].clone();
            }
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            return this;
        }
    }

    private void ensurePage(int index) {
        if (this.pages[index] == null) {
            this.pages[index] = MemContentsSub.createPage(4096, this.width, this.randomize);
        }
    }

    @Override
    public void fill(long start, long len, long value) {
        if (len == 0L) {
            return;
        }
        int pageStart = (int)(start >>> 12);
        int startOffs = (int)(start & 0xFFFL);
        int pageEnd = (int)(start + len - 1L >>> 12);
        int endOffs = (int)(start + len - 1L & 0xFFFL);
        value &= this.mask;
        if (pageStart == pageEnd) {
            this.ensurePage(pageStart);
            long[] vals = new long[(int)len];
            Arrays.fill(vals, value);
            Page page = this.pages[pageStart];
            if (!page.matches(vals, startOffs, this.mask)) {
                long[] oldValues = page.get(startOffs, (int)len);
                page.load(startOffs, vals, this.mask);
                if (value == 0L && page.isClear()) {
                    this.pages[pageStart] = null;
                }
                this.fireBytesChanged(start, len, oldValues);
            }
        } else {
            long[] oldValues;
            long[] vals;
            if (startOffs == 0) {
                --pageStart;
            } else if (value != 0L || this.pages[pageStart] != null) {
                this.ensurePage(pageStart);
                vals = new long[4096 - startOffs];
                Arrays.fill(vals, value);
                Page page = this.pages[pageStart];
                if (!page.matches(vals, startOffs, this.mask)) {
                    oldValues = page.get(startOffs, vals.length);
                    page.load(startOffs, vals, this.mask);
                    if (value == 0L && page.isClear()) {
                        this.pages[pageStart] = null;
                    }
                    this.fireBytesChanged(start, 4096 - pageStart, oldValues);
                }
            }
            if (value == 0L) {
                for (int i = pageStart + 1; i < pageEnd; ++i) {
                    if (this.pages[i] == null) continue;
                    this.clearPage(i);
                }
            } else {
                vals = new long[4096];
                Arrays.fill(vals, value);
                for (int i = pageStart + 1; i < pageEnd; ++i) {
                    this.ensurePage(i);
                    Page page = this.pages[i];
                    if (page.matches(vals, 0L, this.mask)) continue;
                    long[] oldValues2 = page.get(0L, 4096);
                    page.load(0L, vals, this.mask);
                    this.fireBytesChanged(i << 12, 4096L, oldValues2);
                }
            }
            if (endOffs >= 0) {
                Page page = this.pages[pageEnd];
                if (value != 0L || page != null) {
                    this.ensurePage(pageEnd);
                    long[] vals2 = new long[endOffs + 1];
                    Arrays.fill(vals2, value);
                    if (!page.matches(vals2, 0L, this.mask)) {
                        oldValues = page.get(0L, endOffs + 1);
                        page.load(0L, vals2, this.mask);
                        if (value == 0L && page.isClear()) {
                            this.pages[pageEnd] = null;
                        }
                        this.fireBytesChanged(pageEnd << 12, endOffs + 1, oldValues);
                    }
                }
            }
        }
    }

    private void fireBytesChanged(long start, long numBytes, long[] oldValues) {
        if (this.listeners == null) {
            return;
        }
        boolean found = false;
        for (HexModelListener l : this.listeners) {
            found = true;
            l.bytesChanged(this, start, numBytes, oldValues);
        }
        if (!found) {
            this.listeners = null;
        }
    }

    private void fireMetainfoChanged() {
        if (this.listeners == null) {
            return;
        }
        boolean found = false;
        for (HexModelListener l : this.listeners) {
            found = true;
            l.metainfoChanged(this);
        }
        if (!found) {
            this.listeners = null;
        }
    }

    @Override
    public long get(long addr) {
        int page = (int)(addr >>> 12);
        long offs = addr & 0xFFFL;
        if (page < 0 || page >= this.pages.length || this.pages[page] == null) {
            return 0L;
        }
        return this.pages[page].get(offs) & this.mask;
    }

    @Override
    public long getFirstOffset() {
        return 0L;
    }

    @Override
    public long getLastOffset() {
        return (1L << this.addrBits) - 1L;
    }

    public int getLogLength() {
        return this.addrBits;
    }

    @Override
    public int getValueWidth() {
        return this.width;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isClear() {
        for (Page page : this.pages) {
            if (page == null) continue;
            for (int j = page.getLength() - 1; j >= 0; --j) {
                if (page.get(j) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void removeHexModelListener(HexModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.add(l);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    @Override
    public void set(long addr, long value) {
        long val;
        int page = (int)(addr >>> 12);
        long offs = addr & 0xFFFL;
        if (page < 0 || page >= this.pages.length) {
            return;
        }
        long old = this.pages[page] == null ? 0L : this.pages[page].get(offs) & this.mask;
        if (old != (val = value & this.mask)) {
            if (this.pages[page] == null) {
                this.pages[page] = MemContentsSub.createPage(4096, this.width, this.randomize);
            }
            this.pages[page].set(offs, val);
            this.fireBytesChanged(addr, 1L, new long[]{old});
        }
    }

    @Override
    public void set(long start, long[] values) {
        if (values.length == 0) {
            return;
        }
        int pageStart = (int)(start >>> 12);
        int startOffs = (int)(start & 0xFFFL);
        int pageEnd = (int)(start + (long)values.length - 1L >>> 12);
        int endOffs = (int)(start + (long)values.length - 1L & 0xFFFL);
        if (pageStart == pageEnd) {
            this.ensurePage(pageStart);
            Page page = this.pages[pageStart];
            if (!page.matches(values, startOffs, this.mask)) {
                long[] oldValues = page.get(startOffs, values.length);
                page.load(startOffs, values, this.mask);
                if (page.isClear()) {
                    this.pages[pageStart] = null;
                }
                this.fireBytesChanged(start, values.length, oldValues);
            }
        } else {
            long[] vals;
            int nextOffs;
            if (startOffs == 0) {
                --pageStart;
                nextOffs = 0;
            } else {
                this.ensurePage(pageStart);
                vals = new long[4096 - startOffs];
                System.arraycopy(values, 0, vals, 0, vals.length);
                Page page = this.pages[pageStart];
                if (!page.matches(vals, startOffs, this.mask)) {
                    long[] oldValues = page.get(startOffs, vals.length);
                    page.load(startOffs, vals, this.mask);
                    if (page.isClear()) {
                        this.pages[pageStart] = null;
                    }
                    this.fireBytesChanged(start, 4096 - pageStart, oldValues);
                }
                nextOffs = vals.length;
            }
            vals = new long[4096];
            int offs = nextOffs;
            int i = pageStart + 1;
            while (i < pageEnd) {
                Page page = this.pages[i];
                if (page == null) {
                    boolean allZeroes = true;
                    for (int j = 0; j < 4096; ++j) {
                        if ((values[offs + j] & this.mask) == 0L) continue;
                        allZeroes = false;
                        break;
                    }
                    if (!allZeroes) {
                        this.pages[i] = page = MemContentsSub.createPage(4096, this.width, this.randomize);
                    }
                }
                if (page != null) {
                    System.arraycopy(values, offs, vals, 0, 4096);
                    if (!page.matches(vals, startOffs, this.mask)) {
                        long[] oldValues = page.get(0L, 4096);
                        page.load(0L, vals, this.mask);
                        if (page.isClear()) {
                            this.pages[i] = null;
                        }
                        this.fireBytesChanged(i << 12, 4096L, oldValues);
                    }
                }
                ++i;
                offs += 4096;
            }
            if (endOffs >= 0) {
                this.ensurePage(pageEnd);
                vals = new long[endOffs + 1];
                System.arraycopy(values, offs, vals, 0, endOffs + 1);
                Page page = this.pages[pageEnd];
                if (!page.matches(vals, startOffs, this.mask)) {
                    long[] oldValues = page.get(0L, endOffs + 1);
                    page.load(0L, vals, this.mask);
                    if (page.isClear()) {
                        this.pages[pageEnd] = null;
                    }
                    this.fireBytesChanged(pageEnd << 12, endOffs + 1, oldValues);
                }
            }
        }
    }

    public void copyFrom(long start, MemContents src, long offs, int count) {
        if ((count = (int)Math.min((long)count, this.getLastOffset() - start + 1L)) <= 0) {
            return;
        }
        if (src.addrBits != this.addrBits) {
            throw new IllegalArgumentException(String.format("memory width mismatch: src is %d bits wide, dest is %d bits wide", src.addrBits, this.addrBits));
        }
        if (offs + (long)count - 1L > src.getLastOffset()) {
            throw new IllegalArgumentException(String.format("memory offset out of range: offset 0x%x count 0x%x exceeds last valid offset 0x%x", offs, count, src.getLastOffset()));
        }
        int dp = (int)(start >>> 12);
        int di = (int)(start & 0xFFFL);
        int sp = (int)(offs >>> 12);
        int si = (int)(offs & 0xFFFL);
        do {
            Page dstPage = this.pages[dp];
            Page srcPage = src.pages[sp];
            int n = Math.min(count, Math.min(4096 - si, 4096 - di));
            if (dstPage != null || srcPage != null) {
                if (srcPage == null) {
                    this.fill(dp * 4096 + di, n, 0L);
                } else {
                    if (dstPage == null) {
                        dstPage = this.pages[dp] = MemContentsSub.createPage(4096, this.width, this.randomize);
                    }
                    long[] vals = srcPage.get(si, n);
                    dstPage.set((long)di, vals);
                }
            }
            count -= n;
            si += n;
            if ((di += n) >= 4096) {
                di = 0;
                ++dp;
            }
            if (si < 4096) continue;
            si = 0;
            ++sp;
        } while (count > 0);
        this.fireBytesChanged(0L, 1 << this.addrBits, null);
    }

    public void setDimensions(int addrBits, int width) {
        int pageLength;
        int pageCount;
        if (addrBits == this.addrBits && width == this.width) {
            return;
        }
        this.addrBits = addrBits;
        this.width = width;
        this.mask = width == 64 ? -1L : (1L << width) - 1L;
        Page[] oldPages = this.pages;
        if (addrBits < 12) {
            pageCount = 1;
            pageLength = 1 << addrBits;
        } else {
            pageCount = 1 << addrBits - 12;
            pageLength = 4096;
        }
        this.pages = new Page[pageCount];
        if (oldPages != null) {
            int n = Math.min(oldPages.length, this.pages.length);
            for (int i = 0; i < n; ++i) {
                if (oldPages[i] == null) continue;
                this.pages[i] = MemContentsSub.createPage(pageLength, width, this.randomize);
                int m = Math.min(oldPages[i].getLength(), pageLength);
                for (int j = 0; j < m; ++j) {
                    this.pages[i].set((long)j, oldPages[i].get(j));
                }
            }
        }
        if (pageCount == 0 && this.pages[0] == null) {
            this.pages[0] = MemContentsSub.createPage(pageLength, width, this.randomize);
        }
        this.fireMetainfoChanged();
    }

    public void condFillRandom() {
        if (AppPreferences.Memory_Startup_Unknown.get().booleanValue()) {
            int pageLength = this.addrBits < 12 ? 1 << this.addrBits : 4096;
            for (int i = 0; i < this.pages.length; ++i) {
                if (this.pages[i] != null) continue;
                this.pages[i] = MemContentsSub.createPage(pageLength, this.width, this.randomize);
            }
        }
    }

    static abstract class Page
    implements Cloneable {
        Page() {
        }

        public Page clone() {
            try {
                return (Page)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return this;
            }
        }

        abstract long get(long var1);

        long[] get(long start, int len) {
            long[] ret = new long[len];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.get(start + (long)i);
            }
            return ret;
        }

        void set(long start, long[] val) {
            for (int i = 0; i < val.length; ++i) {
                this.set(start + (long)i, val[i]);
            }
        }

        abstract int getLength();

        boolean isClear() {
            int n = this.getLength();
            for (int i = 0; i < n; ++i) {
                if (this.get(i) == 0L) continue;
                return false;
            }
            return true;
        }

        abstract void load(long var1, long[] var3, long var4);

        boolean matches(long[] values, long start, long mask) {
            for (int i = 0; i < values.length; ++i) {
                if (this.get(start + (long)i) == (values[i] & mask)) continue;
                return false;
            }
            return true;
        }

        abstract void set(long var1, long var3);
    }
}

