/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.StringUtil;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JMenuItem;

public class SocSupport {
    private static final long LONG_MASK = 0xFFFFFFFFL;

    public static long convUnsignedInt(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int convUnsignedLong(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    public static void addAllFunctions(PrintWriter h, PrintWriter c, String compName, String functName, int base, int index) {
        SocSupport.addSetterFunction(h, compName, functName, base, index, true);
        SocSupport.addGetterFunction(h, compName, functName, base, index, true);
        h.println();
        SocSupport.addSetterFunction(c, compName, functName, base, index, false);
        SocSupport.addGetterFunction(c, compName, functName, base, index, false);
    }

    public static void addGetterFunction(PrintWriter w, String compName, String functName, int base, int index, boolean header) {
        w.print("unsigned int get" + compName + functName + "()");
        if (header) {
            w.println(";");
            return;
        }
        w.println(" {");
        w.println("  volatile unsigned int* base;");
        w.println("  base = (unsigned int *) " + String.format("0x%X", base) + ";");
        w.println("  return base[" + index + "];");
        w.println("}\n");
    }

    public static void addSetterFunction(PrintWriter w, String compName, String functName, int base, int index, boolean header) {
        w.print("void set" + compName + functName + "(unsigned int value)");
        if (header) {
            w.println(";");
            return;
        }
        w.println(" {");
        w.println("  volatile unsigned int* base;");
        w.println("  base = (unsigned int *) " + String.format("0x%X", base) + ";");
        w.println("  base[" + index + "] = value;");
        w.println("}\n");
    }

    public static JMenuItem createItem(ActionListener l, String label) {
        JMenuItem ret = new JMenuItem(label);
        ret.setEnabled(true);
        ret.addActionListener(l);
        return ret;
    }

    public static String getComponentName(Component comp) {
        String name = comp.getAttributeSet().getValue(StdAttr.LABEL);
        if (StringUtil.isNullOrEmpty(name)) {
            Location loc = comp.getLocation();
            name = String.format("%s@%d,%d", comp.getFactory().getDisplayName(), loc.getX(), loc.getY());
        }
        return name;
    }

    private static String getMasterHierName(CircuitState state) {
        ArrayList<CircuitState> states = new ArrayList<CircuitState>();
        CircuitState s = state;
        while (s.isSubstate()) {
            states.add(s);
            s = s.getParentState();
        }
        StringBuilder name = new StringBuilder();
        name.append(s.getCircuit().getName()).append(":");
        for (int i = states.size() - 1; i >= 0; --i) {
            for (Component c : s.getCircuit().getNonWires()) {
                CircuitState tmp;
                if (!(c.getFactory() instanceof SubcircuitFactory) || !(tmp = (CircuitState)s.getData(c)).equals(states.get(i))) continue;
                name.append(SocSupport.getComponentName(c)).append(":");
            }
            s = (CircuitState)states.get(i);
        }
        return name.toString();
    }

    public static String getMasterName(CircuitState state, Component comp) {
        if (!state.isSubstate()) {
            return SocSupport.getComponentName(comp);
        }
        return SocSupport.getMasterHierName(state) + SocSupport.getComponentName(comp);
    }

    public static String getMasterName(CircuitState state, String compName) {
        if (!state.isSubstate()) {
            return compName;
        }
        return SocSupport.getMasterHierName(state) + compName;
    }
}

