/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.proj;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitLocker;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.gui.log.LogFrame;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.gui.main.SelectionActions;
import com.cburch.logisim.gui.opts.OptionsFrame;
import com.cburch.logisim.gui.test.TestFrame;
import com.cburch.logisim.gui.test.TestThread;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Dependencies;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.EventSourceWeakSupport;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;

public class Project {
    private static final int MAX_UNDO_SIZE = 64;
    private final Simulator simulator = new Simulator();
    private VhdlSimulatorTop vhdlSimulator = null;
    private LogisimFile file;
    private HdlModel hdlModel;
    private CircuitState circuitState;
    private final HashMap<Circuit, CircuitState> recentRootState = new HashMap();
    private final LinkedList<CircuitState> allRootStates = new LinkedList();
    private Frame frame = null;
    private OptionsFrame optionsFrame = null;
    private LogFrame logFrame = null;
    private TestFrame testFrame = null;
    private Tool tool = null;
    private final LinkedList<ActionData> undoLog = new LinkedList();
    private int undoMods = 0;
    private final LinkedList<ActionData> redoLog = new LinkedList();
    private final EventSourceWeakSupport<ProjectListener> projectListeners = new EventSourceWeakSupport();
    private final EventSourceWeakSupport<LibraryListener> fileListeners = new EventSourceWeakSupport();
    private final EventSourceWeakSupport<CircuitListener> circuitListeners = new EventSourceWeakSupport();
    private Dependencies depends;
    private final MyListener myListener = new MyListener();
    private boolean startupScreen = false;
    private boolean forcedDirty = false;

    public Project(LogisimFile file) {
        this.addLibraryListener(this.myListener);
        this.setLogisimFile(file);
    }

    public void addCircuitListener(CircuitListener value) {
        this.circuitListeners.add(value);
        Circuit current = this.getCurrentCircuit();
        if (current != null) {
            current.addCircuitListener(value);
        }
    }

    public void addLibraryListener(LibraryListener value) {
        this.fileListeners.add(value);
        if (this.file != null) {
            this.file.addLibraryListener(value);
        }
    }

    public void addProjectListener(ProjectListener what) {
        this.projectListeners.add(what);
    }

    public boolean confirmClose(String title) {
        return this.frame.confirmClose(title);
    }

    public JFileChooser createChooser() {
        if (this.file == null) {
            return JFileChoosers.create();
        }
        Loader loader = this.file.getLoader();
        return loader == null ? JFileChoosers.create() : loader.createChooser();
    }

    public void doAction(Action act) {
        if (act == null) {
            return;
        }
        Action toAdd = act;
        this.startupScreen = false;
        this.redoLog.clear();
        if (!this.undoLog.isEmpty() && act.shouldAppendTo(this.getLastAction())) {
            ActionData firstData = this.undoLog.removeLast();
            Action first = firstData.action;
            if (first.isModification()) {
                --this.undoMods;
            }
            if ((toAdd = first.append(act)) != null) {
                this.undoLog.add(new ActionData(this.circuitState, this.hdlModel, toAdd));
                if (toAdd.isModification()) {
                    ++this.undoMods;
                }
            }
            this.fireEvent(new ProjectEvent(5, this, act));
            try {
                act.doIt(this);
            }
            catch (CircuitLocker.LockException e) {
                System.out.println("*** Circuit Lock Bug Diagnostics ***");
                System.out.println("This thread: " + String.valueOf(Thread.currentThread()));
                System.out.println("attempted to access without any locks:");
                System.out.printf("  circuit \"%s\" [lock serial: %d/%d]\n", e.getCircuit().getName(), e.getSerialNumber(), e.getCircuit().getLocker().getSerialNumber());
                System.out.println("  owned by thread: " + String.valueOf(e.getMutatingThread()));
                System.out.println("  with mutator: " + String.valueOf(e.getCircuitMutator()));
                throw e;
            }
            this.file.setDirty(this.isFileDirty());
            this.fireEvent(new ProjectEvent(6, this, act));
            this.fireEvent(new ProjectEvent(7, this, first, toAdd));
            return;
        }
        this.undoLog.add(new ActionData(this.circuitState, this.hdlModel, toAdd));
        this.fireEvent(new ProjectEvent(5, this, act));
        try {
            act.doIt(this);
        }
        catch (CircuitLocker.LockException e) {
            System.out.println("*** Circuit Lock Bug Diagnostics ***");
            System.out.println("This thread: " + String.valueOf(Thread.currentThread()));
            System.out.println("attempted to access without any locks:");
            System.out.printf("  circuit \"%s\" [lock serial: %d/%d]\n", e.getCircuit().getName(), e.getSerialNumber(), e.getCircuit().getLocker().getSerialNumber());
            System.out.println("  owned by thread: " + String.valueOf(e.getMutatingThread()));
            System.out.println("  with mutator: " + String.valueOf(e.getCircuitMutator()));
            throw e;
        }
        while (this.undoLog.size() > 64) {
            this.undoLog.removeFirst();
        }
        if (toAdd.isModification()) {
            ++this.undoMods;
        }
        this.file.setDirty(this.isFileDirty());
        this.fireEvent(new ProjectEvent(6, this, act));
    }

    public int doTestVector(String vectorname, String name) {
        Circuit circuit;
        Circuit circuit2 = circuit = name == null ? this.file.getMainCircuit() : this.file.getCircuit(name);
        if (circuit == null) {
            System.err.println("Circuit '" + name + "' not found.");
            return -1;
        }
        this.setCurrentCircuit(circuit);
        return TestThread.doTestVector(this, circuit, vectorname);
    }

    private void fireEvent(int action, Object data) {
        this.fireEvent(new ProjectEvent(action, this, data));
    }

    private void fireEvent(int action, Object old, Object data) {
        this.fireEvent(new ProjectEvent(action, this, old, data));
    }

    private void fireEvent(ProjectEvent event) {
        for (ProjectListener l : this.projectListeners) {
            l.projectChanged(event);
        }
    }

    public boolean getCanRedo() {
        return this.redoLog.size() > 0;
    }

    public List<CircuitState> getRootCircuitStates() {
        return this.allRootStates;
    }

    public CircuitState getCircuitState() {
        return this.circuitState;
    }

    public CircuitState getCircuitState(Circuit circuit) {
        if (this.circuitState != null && this.circuitState.getCircuit() == circuit) {
            return this.circuitState;
        }
        CircuitState ret = this.recentRootState.get(circuit);
        if (ret == null) {
            ret = CircuitState.createRootState(this, circuit);
            this.recentRootState.put(circuit, ret);
            this.allRootStates.add(ret);
        }
        return ret;
    }

    public Circuit getCurrentCircuit() {
        return this.circuitState == null ? null : this.circuitState.getCircuit();
    }

    public HdlModel getCurrentHdl() {
        return this.hdlModel;
    }

    public void setCurrentHdlModel(HdlModel hdl) {
        Circuit oldCircuit;
        if (this.hdlModel == hdl) {
            return;
        }
        this.setTool(null);
        CircuitState old = this.circuitState;
        HdlModel oldHdl = this.hdlModel;
        Circuit circuit = oldCircuit = old == null ? null : old.getCircuit();
        if (oldCircuit != null) {
            for (CircuitListener l : this.circuitListeners) {
                oldCircuit.removeCircuitListener(l);
            }
        }
        this.circuitState = null;
        this.hdlModel = hdl;
        if (old != null) {
            this.simulator.setCircuitState(null);
        }
        Object oldActive = old;
        if (oldHdl != null) {
            oldActive = oldHdl;
        }
        this.fireEvent(1, oldActive, hdl);
        if (old != null) {
            this.fireEvent(4, old, null);
        }
        if (oldCircuit != null) {
            oldCircuit.displayChanged();
        }
        if (oldHdl != null) {
            oldHdl.displayChanged();
        }
        hdl.displayChanged();
    }

    public Dependencies getDependencies() {
        return this.depends;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Action getLastAction() {
        if (this.undoLog.size() == 0) {
            return null;
        }
        return this.undoLog.getLast().action;
    }

    public Action getLastRedoAction() {
        if (this.redoLog.size() == 0) {
            return null;
        }
        return this.redoLog.getLast().action;
    }

    public LogFrame getLogFrame() {
        if (this.logFrame == null) {
            this.logFrame = new LogFrame(this);
        }
        return this.logFrame;
    }

    public LogisimFile getLogisimFile() {
        return this.file;
    }

    public Options getOptions() {
        return this.file.getOptions();
    }

    public OptionsFrame getOptionsFrame() {
        if (this.optionsFrame == null) {
            this.optionsFrame = new OptionsFrame(this);
        }
        return this.optionsFrame;
    }

    public Selection getSelection() {
        if (this.frame == null) {
            return null;
        }
        Canvas canvas = this.frame.getCanvas();
        if (canvas == null) {
            return null;
        }
        return canvas.getSelection();
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public TestFrame getTestFrame() {
        if (this.testFrame == null) {
            this.testFrame = new TestFrame(this);
        }
        return this.testFrame;
    }

    public Tool getTool() {
        return this.tool;
    }

    public VhdlSimulatorTop getVhdlSimulator() {
        if (this.vhdlSimulator == null) {
            this.vhdlSimulator = new VhdlSimulatorTop(this);
        }
        return this.vhdlSimulator;
    }

    public boolean isFileDirty() {
        return this.undoMods > 0 || this.forcedDirty;
    }

    public boolean isStartupScreen() {
        return this.startupScreen;
    }

    public void setForcedDirty() {
        this.forcedDirty = true;
        this.file.setDirty(true);
    }

    public void redoAction() {
        if (CollectionUtil.isNotEmpty(this.redoLog)) {
            this.undoLog.addLast(this.redoLog.getLast());
            ++this.undoMods;
            ActionData data = this.redoLog.removeLast();
            if (data.circuitState != null) {
                this.setCircuitState(data.circuitState);
            } else if (data.hdlModel != null) {
                this.setCurrentHdlModel(data.hdlModel);
            }
            Action action = data.action;
            this.fireEvent(new ProjectEvent(11, this, action));
            action.doIt(this);
            this.fireEvent(new ProjectEvent(12, this, action));
        }
    }

    public void removeCircuitListener(CircuitListener value) {
        this.circuitListeners.remove(value);
        Circuit current = this.getCurrentCircuit();
        if (current != null) {
            current.removeCircuitListener(value);
        }
    }

    public void removeLibraryListener(LibraryListener value) {
        this.fileListeners.remove(value);
        if (this.file != null) {
            this.file.removeLibraryListener(value);
        }
    }

    public void removeProjectListener(ProjectListener what) {
        this.projectListeners.remove(what);
    }

    public void repaintCanvas() {
        this.fireEvent(new ProjectEvent(10, this, null));
    }

    public void setCircuitState(CircuitState value) {
        boolean circuitChanged;
        if (value == null || this.circuitState == value) {
            return;
        }
        CircuitState old = this.circuitState;
        HdlModel oldHdl = this.hdlModel;
        Object oldActive = old;
        if (oldHdl != null) {
            oldActive = oldHdl;
        }
        Circuit oldCircuit = old == null ? null : old.getCircuit();
        Circuit newCircuit = value.getCircuit();
        boolean bl = circuitChanged = old == null || oldCircuit != newCircuit;
        if (circuitChanged) {
            Object canvas;
            Object object = canvas = this.frame == null ? null : this.frame.getCanvas();
            if (canvas != null) {
                Action act;
                Object selection;
                if (this.tool != null) {
                    this.tool.deselect((Canvas)canvas);
                }
                if ((selection = ((Canvas)canvas).getSelection()) != null && (act = SelectionActions.dropAll((Selection)selection)) != null) {
                    this.doAction(act);
                }
                if (this.tool != null) {
                    this.tool.select((Canvas)canvas);
                }
            }
            if (oldCircuit != null) {
                for (CircuitListener l : this.circuitListeners) {
                    oldCircuit.removeCircuitListener(l);
                }
            }
        }
        this.hdlModel = null;
        this.circuitState = value;
        if (this.circuitState.getParentState() == null) {
            this.recentRootState.put(newCircuit, this.circuitState);
        }
        this.simulator.setCircuitState(this.circuitState);
        if (circuitChanged) {
            this.fireEvent(1, oldActive, newCircuit);
            if (newCircuit != null) {
                for (CircuitListener l : this.circuitListeners) {
                    newCircuit.addCircuitListener(l);
                }
                double circTickFrequency = newCircuit.getTickFrequency();
                double simTickFrequency = this.simulator.getTickFrequency();
                if (circTickFrequency < 0.0) {
                    newCircuit.setTickFrequency(simTickFrequency);
                } else if (circTickFrequency != simTickFrequency) {
                    this.simulator.setTickFrequency(circTickFrequency);
                }
            }
            if (oldCircuit != null) {
                oldCircuit.displayChanged();
            }
            if (oldHdl != null) {
                oldHdl.displayChanged();
            }
            newCircuit.displayChanged();
        }
        this.fireEvent(4, old, this.circuitState);
    }

    public void setCurrentCircuit(Circuit circuit) {
        CircuitState circState = this.recentRootState.get(circuit);
        if (circState == null) {
            circState = CircuitState.createRootState(this, circuit);
            this.recentRootState.put(circuit, circState);
            this.allRootStates.add(circState);
        }
        this.setCircuitState(circState);
    }

    public void setFileAsClean() {
        this.undoMods = 0;
        this.forcedDirty = false;
        this.file.setDirty(this.isFileDirty());
    }

    public void setFileAsDirty() {
        this.file.setDirty(true);
    }

    public void setFrame(Frame value) {
        if (this.frame == value) {
            return;
        }
        Frame oldValue = this.frame;
        this.frame = value;
        Projects.windowCreated(this, oldValue, value);
        value.getCanvas().getSelection().addListener(this.myListener);
    }

    public void setLogisimFile(LogisimFile value) {
        LogisimFile old = this.file;
        if (old != null) {
            for (LibraryListener l : this.fileListeners) {
                old.removeLibraryListener(l);
            }
        }
        if (this.optionsFrame != null) {
            this.optionsFrame.dispose();
            this.optionsFrame = null;
        }
        this.file = value;
        this.recentRootState.clear();
        this.allRootStates.clear();
        this.depends = new Dependencies(this.file);
        this.undoLog.clear();
        this.redoLog.clear();
        this.undoMods = 0;
        this.fireEvent(0, old, this.file);
        this.setCurrentCircuit(this.file.getMainCircuit());
        if (this.file != null) {
            for (LibraryListener l : this.fileListeners) {
                this.file.addLibraryListener(l);
            }
        }
        this.file.setDirty(true);
        this.file.setDirty(false);
    }

    public void setStartupScreen(boolean value) {
        this.startupScreen = value;
    }

    public void setTool(Tool value) {
        Action act;
        Selection selection;
        if (this.tool == value) {
            return;
        }
        Tool old = this.tool;
        Canvas canvas = this.frame.getCanvas();
        if (old != null) {
            old.deselect(canvas);
        }
        if (!((selection = canvas.getSelection()) == null || selection.isEmpty() || value != null && this.getOptions().getMouseMappings().containsSelectTool() || (act = SelectionActions.anchorAll(selection)) == null)) {
            this.doAction(act);
        }
        this.startupScreen = false;
        this.tool = value;
        if (this.tool != null) {
            this.tool.select(this.frame.getCanvas());
        }
        this.fireEvent(2, old, this.tool);
    }

    public void undoAction() {
        if (CollectionUtil.isNotEmpty(this.undoLog)) {
            this.redoLog.addLast(this.undoLog.getLast());
            ActionData data = this.undoLog.removeLast();
            if (data.circuitState != null) {
                this.setCircuitState(data.circuitState);
            } else if (data.hdlModel != null) {
                this.setCurrentHdlModel(data.hdlModel);
            }
            Action action = data.action;
            if (action.isModification()) {
                --this.undoMods;
            }
            this.fireEvent(new ProjectEvent(8, this, action));
            action.undo(this);
            this.file.setDirty(this.isFileDirty());
            this.fireEvent(new ProjectEvent(9, this, action));
        }
    }

    private class MyListener
    implements Selection.Listener,
    LibraryListener {
        private MyListener() {
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            SubcircuitFactory fact;
            ComponentFactory factory;
            Object data;
            int action = event.getAction();
            if (action == 4) {
                Library unloaded = (Library)event.getData();
                if (Project.this.tool != null && unloaded.containsFromSource(Project.this.tool)) {
                    Project.this.setTool(null);
                }
            } else if (action == 1 && (data = event.getData()) instanceof AddTool && (factory = ((AddTool)data).getFactory()) instanceof SubcircuitFactory && (fact = (SubcircuitFactory)factory).getSubcircuit() == Project.this.getCurrentCircuit()) {
                Project.this.setCurrentCircuit(Project.this.file.getMainCircuit());
            }
        }

        @Override
        public void selectionChanged(Selection.Event e) {
            Project.this.fireEvent(3, e.getSource());
        }
    }

    private static class ActionData {
        final CircuitState circuitState;
        final HdlModel hdlModel;
        final Action action;

        public ActionData(CircuitState circuitState, HdlModel hdlModel, Action action) {
            this.circuitState = circuitState;
            this.hdlModel = hdlModel;
            this.action = action;
        }
    }
}

