/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.prefs.AbstractPrefMonitor;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;

public class PrefMonitorKeyStroke
extends AbstractPrefMonitor<KeyStroke> {
    private final byte[] defaultData;
    private byte[] value;
    private String prefName;
    private boolean canModify = true;
    private boolean metaRequired = false;

    public PrefMonitorKeyStroke(String name, int keycode, int modifier) {
        super(name);
        this.prefName = name;
        this.defaultData = this.keystrokeToByteArray(new KeyStroke[]{KeyStroke.getKeyStroke(keycode, modifier)});
        this.value = this.keystrokeToByteArray(new KeyStroke[]{KeyStroke.getKeyStroke(keycode, modifier)});
        Preferences prefs = AppPreferences.getPrefs();
        this.set(prefs.getByteArray(name, this.defaultData));
        prefs.addPreferenceChangeListener(this);
    }

    public PrefMonitorKeyStroke(String name, int keycode, int modifier, boolean metaRequired, boolean canModify) {
        super(name);
        this.prefName = name;
        this.defaultData = this.keystrokeToByteArray(new KeyStroke[]{KeyStroke.getKeyStroke(keycode, modifier)});
        this.value = this.keystrokeToByteArray(new KeyStroke[]{KeyStroke.getKeyStroke(keycode, modifier)});
        Preferences prefs = AppPreferences.getPrefs();
        this.set(prefs.getByteArray(name, this.defaultData));
        prefs.addPreferenceChangeListener(this);
        this.metaRequired = metaRequired;
        this.canModify = canModify;
    }

    public PrefMonitorKeyStroke(String name, KeyStroke[] multipleValues) {
        super(name);
        this.prefName = name;
        this.defaultData = this.keystrokeToByteArray(multipleValues);
        this.value = this.keystrokeToByteArray(multipleValues);
        Preferences prefs = AppPreferences.getPrefs();
        this.set(prefs.getByteArray(name, this.defaultData));
        prefs.addPreferenceChangeListener(this);
    }

    public Boolean canModify() {
        return this.canModify;
    }

    public Boolean needMetaKey() {
        return this.metaRequired;
    }

    public boolean metaCheckPass(int modifier) {
        if (this.metaRequired) {
            return (modifier & AppPreferences.hotkeyMenuMask) == AppPreferences.hotkeyMenuMask;
        }
        return true;
    }

    public String getName() {
        return this.prefName;
    }

    private byte[] keystrokeToByteArray(KeyStroke[] keyStrokes) {
        byte[] res = new byte[keyStrokes.length * 8];
        int cnt = 0;
        for (KeyStroke k : keyStrokes) {
            int code = k.getKeyCode();
            res[cnt + 0] = (byte)(code & 0xFF);
            res[cnt + 1] = (byte)(code >> 8 & 0xFF);
            res[cnt + 2] = (byte)(code >> 16 & 0xFF);
            res[cnt + 3] = (byte)(code >> 24 & 0xFF);
            int mod = k.getModifiers();
            res[cnt + 4] = (byte)(mod & 0xFF);
            res[cnt + 5] = (byte)(mod >> 8 & 0xFF);
            res[cnt + 6] = (byte)(mod >> 16 & 0xFF);
            res[cnt + 7] = (byte)(mod >> 24 & 0xFF);
            cnt += 8;
        }
        return res;
    }

    private List<KeyStroke> byteArrayToKeyStroke(byte[] b) {
        ArrayList<KeyStroke> list = new ArrayList<KeyStroke>();
        for (int i = 0; i < b.length; i += 8) {
            int code = 0;
            code |= b[i + 0] & 0xFF;
            code |= b[i + 1] << 8 & 0xFF00;
            code |= b[i + 2] << 16 & 0xFF0000;
            int mod = 0;
            mod |= b[i + 4] & 0xFF;
            mod |= b[i + 5] << 8 & 0xFF00;
            mod |= b[i + 6] << 16 & 0xFF0000;
            list.add(KeyStroke.getKeyStroke(code |= b[i + 3] << 24 & 0xFF000000, mod |= b[i + 7] << 24 & 0xFF000000));
        }
        return list;
    }

    @Override
    public KeyStroke get() {
        return this.byteArrayToKeyStroke(this.value).get(0);
    }

    public List<KeyStroke> getList() {
        return this.byteArrayToKeyStroke(this.value);
    }

    public KeyStroke getWithMask(int mask) {
        KeyStroke tmp = this.byteArrayToKeyStroke(this.value).get(0);
        return KeyStroke.getKeyStroke(tmp.getKeyCode(), tmp.getModifiers() | mask);
    }

    public boolean compare(int keyCode, int modifier) {
        String userString = InputEvent.getModifiersExText(modifier) + "+" + KeyEvent.getKeyText(keyCode);
        for (KeyStroke tmp : this.getList()) {
            String compareString = InputEvent.getModifiersExText(tmp.getModifiers()) + "+" + KeyEvent.getKeyText(tmp.getKeyCode());
            if (!compareString.equals(userString)) continue;
            return true;
        }
        return false;
    }

    public String getDisplayString() {
        StringBuilder res = new StringBuilder();
        List<KeyStroke> list = this.getList();
        int cnt = 0;
        for (KeyStroke tmp : list) {
            String modifierString = InputEvent.getModifiersExText(tmp.getModifiers());
            if (modifierString.isEmpty()) {
                res.append(KeyEvent.getKeyText(tmp.getKeyCode()));
            } else {
                res.append(modifierString).append("+").append(KeyEvent.getKeyText(tmp.getKeyCode()));
            }
            if (++cnt >= list.size()) continue;
            res.append(" / ");
        }
        return res.toString();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String name;
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.equals(name = this.getIdentifier())) {
            byte[] oldValue = this.value;
            byte[] newValue = prefs.getByteArray(name, this.defaultData);
            if (newValue != oldValue) {
                this.value = newValue;
                AppPreferences.firePropertyChange(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void set(byte[] newValue) {
        if (this.value != newValue) {
            AppPreferences.getPrefs().putByteArray(this.getIdentifier(), newValue);
        }
    }

    @Override
    public void set(KeyStroke newValue) {
        byte[] newVal = this.keystrokeToByteArray(new KeyStroke[]{newValue});
        if (this.value != newVal) {
            AppPreferences.getPrefs().putByteArray(this.getIdentifier(), newVal);
        }
    }

    @Override
    public void set(KeyStroke[] newValue) {
        byte[] newVal = this.keystrokeToByteArray(newValue);
        if (this.value != newVal) {
            AppPreferences.getPrefs().putByteArray(this.getIdentifier(), newVal);
        }
    }
}

