/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.StringGetter;

public class Port {
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    public static final String INOUT = "inout";
    public static final String EXCLUSIVE = "exclusive";
    public static final String SHARED = "shared";
    public static final String CLOCK = "clock";
    private final int dx;
    private final int dy;
    private final int type;
    private final BitWidth widthFixed;
    private final Attribute<BitWidth> widthAttr;
    private final boolean exclude;
    private StringGetter toolTip;

    private static String defaultExclusive(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Null port type");
        }
        if (s.equals(INPUT)) {
            return SHARED;
        }
        if (s.equals(OUTPUT)) {
            return EXCLUSIVE;
        }
        if (s.equals(INOUT)) {
            return SHARED;
        }
        throw new IllegalArgumentException("Not recognized port type: " + s);
    }

    private static boolean toExclusive(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Null exclusion type");
        }
        if (s.equals(EXCLUSIVE)) {
            return true;
        }
        if (s.equals(SHARED)) {
            return false;
        }
        throw new IllegalArgumentException("Not recognized exclusion type: " + s);
    }

    private static int toType(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Null port type");
        }
        if (s.equals(INPUT)) {
            return 1;
        }
        if (s.equals(OUTPUT)) {
            return 2;
        }
        if (s.equals(INOUT)) {
            return 3;
        }
        throw new IllegalArgumentException("Not recognized port type: " + s);
    }

    public Port(int dx, int dy, String type, Attribute<BitWidth> attr) {
        this(dx, dy, type, attr, Port.defaultExclusive(type));
    }

    public Port(int dx, int dy, String type, Attribute<BitWidth> attr, String exclude) {
        this.dx = dx;
        this.dy = dy;
        this.type = Port.toType(type);
        this.widthFixed = null;
        this.widthAttr = attr;
        this.exclude = Port.toExclusive(exclude);
        this.toolTip = null;
    }

    public Port(int dx, int dy, String type, BitWidth bits) {
        this(dx, dy, type, bits, Port.defaultExclusive(type));
    }

    public Port(int dx, int dy, String type, BitWidth bits, String exclude) {
        this.dx = dx;
        this.dy = dy;
        this.type = Port.toType(type);
        this.widthFixed = bits;
        this.widthAttr = null;
        this.exclude = Port.toExclusive(exclude);
        this.toolTip = null;
    }

    public Port(int dx, int dy, String type, int bits) {
        this(dx, dy, type, BitWidth.create(bits), Port.defaultExclusive(type));
    }

    public Port(int dx, int dy, String type, int bits, String exclude) {
        this(dx, dy, type, BitWidth.create(bits), exclude);
    }

    public BitWidth getFixedBitWidth() {
        return this.widthFixed == null ? BitWidth.UNKNOWN : this.widthFixed;
    }

    public String getToolTip() {
        StringGetter getter = this.toolTip;
        return getter == null ? null : getter.toString();
    }

    public int getType() {
        return this.type;
    }

    public Attribute<BitWidth> getWidthAttribute() {
        return this.widthAttr;
    }

    public void setToolTip(StringGetter value) {
        this.toolTip = value;
    }

    public EndData toEnd(Location loc, AttributeSet attrs) {
        Location pt = loc.translate(this.dx, this.dy);
        if (this.widthFixed != null) {
            return new EndData(pt, this.widthFixed, this.type, this.exclude);
        }
        BitWidth val = attrs.getValue(this.widthAttr);
        if (val instanceof BitWidth) {
            return new EndData(pt, val, this.type, this.exclude);
        }
        throw new IllegalArgumentException("Width attribute not set");
    }
}

