/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.fpga.gui.ZoomSlider;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.prefs.ColorChooserButton;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PrefBoolean;
import com.cburch.logisim.gui.prefs.PrefOption;
import com.cburch.logisim.gui.prefs.PrefOptionList;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.util.TableLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class WindowOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final PrefBoolean[] checks;
    private final PrefOptionList canvasPlacement;
    private final PrefOptionList toolbarPlacement;
    private final JButton resetWindowLayoutButton;
    private final ColorChooserButton canvasBgColor;
    private final JLabel canvasBgColorTitle;
    private final ColorChooserButton gridBgColor;
    private final JLabel gridBgColorTitle;
    private final ColorChooserButton gridDotColor;
    private final JLabel gridDotColorTitle;
    private final ColorChooserButton gridZoomedDotColor;
    private final JLabel gridZoomedDotColorTitle;
    private final ColorChooserButton componentColor;
    private final JLabel componentColorTitle;
    private final ColorChooserButton componentIconColor;
    private final JLabel componentIconColorTitle;
    private final JButton gridColorsResetButton;
    private final ZoomSlider zoomValue;
    private final JButton zoomAutoButton;
    private final JLabel lookfeelLabel;
    private final JLabel zoomLabel;
    private final JLabel importantA;
    private final JTextArea importantB;
    private final JPanel previewContainer;
    private final JComboBox<String> lookAndFeel;
    private final UIManager.LookAndFeelInfo[] lookAndFeelInfos;
    private JPanel previewPanel;
    private int index = 0;
    protected final String cmdResetWindowLayout = "reset-window-layout";
    protected final String cmdResetGridColors = "reset-grid-colors";
    protected final String cmdSetAutoScaleFactor = "set-auto-scale-factor";

    public WindowOptions(PreferencesFrame window) {
        super(window);
        SettingsChangeListener listener = new SettingsChangeListener();
        JPanel panel = new JPanel(new TableLayout(2));
        this.checks = new PrefBoolean[]{new PrefBoolean(AppPreferences.SHOW_TICK_RATE, Strings.S.getter("windowTickRate"))};
        this.canvasPlacement = new PrefOptionList(AppPreferences.CANVAS_PLACEMENT, Strings.S.getter("windowCanvasLocation"), new PrefOption[]{new PrefOption(Direction.EAST.toString(), Direction.EAST.getDisplayGetter()), new PrefOption(Direction.WEST.toString(), Direction.WEST.getDisplayGetter())});
        this.toolbarPlacement = new PrefOptionList(AppPreferences.TOOLBAR_PLACEMENT, Strings.S.getter("windowToolbarLocation"), new PrefOption[]{new PrefOption(Direction.NORTH.toString(), Direction.NORTH.getDisplayGetter()), new PrefOption(Direction.SOUTH.toString(), Direction.SOUTH.getDisplayGetter()), new PrefOption(Direction.EAST.toString(), Direction.EAST.getDisplayGetter()), new PrefOption(Direction.WEST.toString(), Direction.WEST.getDisplayGetter()), new PrefOption("hidden", Strings.S.getter("windowToolbarHidden"))});
        panel.add(this.canvasPlacement.getJLabel());
        panel.add(this.canvasPlacement.getJComboBox());
        panel.add(this.toolbarPlacement.getJLabel());
        panel.add(this.toolbarPlacement.getJComboBox());
        this.canvasBgColorTitle = new JLabel(Strings.S.get("windowCanvasBgColor"));
        this.canvasBgColor = new ColorChooserButton(window, AppPreferences.CANVAS_BG_COLOR);
        panel.add(this.canvasBgColorTitle);
        panel.add(this.canvasBgColor);
        this.gridBgColorTitle = new JLabel(Strings.S.get("windowGridBgColor"));
        this.gridBgColor = new ColorChooserButton(window, AppPreferences.GRID_BG_COLOR);
        panel.add(this.gridBgColorTitle);
        panel.add(this.gridBgColor);
        this.gridDotColorTitle = new JLabel(Strings.S.get("windowGridDotColor"));
        this.gridDotColor = new ColorChooserButton(window, AppPreferences.GRID_DOT_COLOR);
        panel.add(this.gridDotColorTitle);
        panel.add(this.gridDotColor);
        this.gridZoomedDotColorTitle = new JLabel(Strings.S.get("windowGridZoomedDotColor"));
        this.gridZoomedDotColor = new ColorChooserButton(window, AppPreferences.GRID_ZOOMED_DOT_COLOR);
        panel.add(this.gridZoomedDotColorTitle);
        panel.add(this.gridZoomedDotColor);
        this.componentColorTitle = new JLabel(Strings.S.get("windowComponentColor"));
        this.componentColor = new ColorChooserButton(window, AppPreferences.COMPONENT_COLOR);
        panel.add(this.componentColorTitle);
        panel.add(this.componentColor);
        this.componentIconColorTitle = new JLabel(Strings.S.get("windowComponentIconColor"));
        this.componentIconColor = new ColorChooserButton(window, AppPreferences.COMPONENT_ICON_COLOR);
        panel.add(this.componentIconColorTitle);
        panel.add(this.componentIconColor);
        this.gridColorsResetButton = new JButton();
        this.gridColorsResetButton.addActionListener(listener);
        this.gridColorsResetButton.setActionCommand("reset-grid-colors");
        this.gridColorsResetButton.setText(Strings.S.get("windowGridColorsReset"));
        panel.add(new JLabel());
        panel.add(this.gridColorsResetButton);
        panel.add(new JLabel(" "));
        panel.add(new JLabel(" "));
        this.importantA = new JLabel(Strings.S.get("windowToolbarPleaserestart"));
        this.importantA.setFont(this.importantA.getFont().deriveFont(2));
        panel.add(this.importantA);
        this.importantB = new JTextArea(Strings.S.get("windowToolbarImportant"));
        this.importantB.setFont(this.importantB.getFont().deriveFont(2));
        panel.add(this.importantB);
        this.zoomLabel = new JLabel(Strings.S.get("windowToolbarZoomfactor"));
        this.zoomValue = new ZoomSlider(0, 100, 300, (int)(AppPreferences.SCALE_FACTOR.get() * 100.0));
        this.zoomAutoButton = new JButton();
        this.zoomAutoButton.addActionListener(listener);
        this.zoomAutoButton.setActionCommand("set-auto-scale-factor");
        this.zoomAutoButton.setText(Strings.S.get("windowSetAutoScaleFactor"));
        panel.add(this.zoomLabel);
        panel.add(this.zoomValue);
        panel.add(new JLabel(" "));
        panel.add(this.zoomAutoButton);
        this.zoomValue.addChangeListener(listener);
        panel.add(new JLabel(" "));
        panel.add(new JLabel(" "));
        int index = 0;
        this.lookAndFeel = new JComboBox();
        this.lookAndFeel.setSize(50, 20);
        for (UIManager.LookAndFeelInfo info : this.lookAndFeelInfos = UIManager.getInstalledLookAndFeels()) {
            this.lookAndFeel.insertItemAt(info.getName(), index);
            if (info.getClassName().equals(AppPreferences.LookAndFeel.get())) {
                this.lookAndFeel.setSelectedIndex(index);
                this.index = index;
            }
            ++index;
        }
        this.lookfeelLabel = new JLabel(Strings.S.get("windowToolbarLookandfeel"));
        panel.add(this.lookfeelLabel);
        panel.add(this.lookAndFeel);
        this.lookAndFeel.addActionListener(listener);
        JLabel previewLabel = new JLabel(Strings.S.get("windowToolbarPreview"));
        panel.add(previewLabel);
        this.previewContainer = new JPanel();
        panel.add(this.previewContainer);
        this.initThemePreviewer();
        this.setLayout(new TableLayout(1));
        this.resetWindowLayoutButton = new JButton();
        this.resetWindowLayoutButton.addActionListener(listener);
        this.resetWindowLayoutButton.setActionCommand("reset-window-layout");
        this.resetWindowLayoutButton.setText(Strings.S.get("windowToolbarReset"));
        this.add(this.resetWindowLayoutButton);
        for (PrefBoolean check : this.checks) {
            this.add(check);
        }
        this.add(panel);
    }

    private void initThemePreviewer() {
        if (this.previewPanel != null) {
            this.previewContainer.remove(this.previewPanel);
        }
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(AppPreferences.LookAndFeel.get());
            this.previewPanel = new JPanel();
            this.previewPanel.add(new JButton("Preview"));
            this.previewPanel.add(new JCheckBox("Preview"));
            this.previewPanel.add(new JRadioButton("Preview"));
            this.previewPanel.add(new JComboBox<String>(new String[]{"Preview 1", "Preview 2"}));
            this.previewContainer.add(this.previewPanel);
            UIManager.setLookAndFeel(previousLF);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        this.previewContainer.repaint();
        this.previewContainer.revalidate();
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("windowHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("windowTitle");
    }

    @Override
    public void localeChanged() {
        for (PrefBoolean check : this.checks) {
            check.localeChanged();
        }
        this.toolbarPlacement.localeChanged();
        this.zoomLabel.setText(Strings.S.get("windowToolbarZoomfactor"));
        this.lookfeelLabel.setText(Strings.S.get("windowToolbarLookandfeel"));
        this.importantA.setText(Strings.S.get("windowToolbarPleaserestart"));
        this.importantB.setText(Strings.S.get("windowToolbarImportant"));
        this.resetWindowLayoutButton.setText(Strings.S.get("windowToolbarReset"));
        this.canvasBgColorTitle.setText(Strings.S.get("windowCanvasBgColor"));
        this.gridBgColorTitle.setText(Strings.S.get("windowGridBgColor"));
        this.gridDotColorTitle.setText(Strings.S.get("windowGridDotColor"));
        this.gridZoomedDotColorTitle.setText(Strings.S.get("windowGridZoomedDotColor"));
        this.componentColorTitle.setText(Strings.S.get("windowComponentColor"));
        this.gridColorsResetButton.setText(Strings.S.get("windowGridColorsReset"));
        this.zoomAutoButton.setText(Strings.S.get("windowSetAutoScaleFactor"));
    }

    private class SettingsChangeListener
    implements ChangeListener,
    ActionListener {
        private SettingsChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            if (!source.getValueIsAdjusting()) {
                int value = source.getValue();
                AppPreferences.SCALE_FACTOR.set((double)value / 100.0);
                List<Project> nowOpen = Projects.getOpenProjects();
                for (Project proj : nowOpen) {
                    proj.getFrame().revalidate();
                    proj.getFrame().repaint();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(WindowOptions.this.lookAndFeel)) {
                if (WindowOptions.this.lookAndFeel.getSelectedIndex() != WindowOptions.this.index) {
                    WindowOptions.this.index = WindowOptions.this.lookAndFeel.getSelectedIndex();
                    AppPreferences.LookAndFeel.set(WindowOptions.this.lookAndFeelInfos[WindowOptions.this.index].getClassName());
                    WindowOptions.this.initThemePreviewer();
                }
            } else if (e.getActionCommand().equals("reset-window-layout")) {
                AppPreferences.resetWindow();
                List<Project> nowOpen = Projects.getOpenProjects();
                for (Project proj : nowOpen) {
                    proj.getFrame().resetLayout();
                    proj.getFrame().revalidate();
                    proj.getFrame().repaint();
                }
            } else if (e.getActionCommand().equals("reset-grid-colors")) {
                List<Project> nowOpen = Projects.getOpenProjects();
                AppPreferences.setDefaultGridColors();
                for (Project proj : nowOpen) {
                    proj.getFrame().repaint();
                }
            } else if (e.getActionCommand().equals("set-auto-scale-factor")) {
                double tmp = AppPreferences.getAutoScaleFactor();
                AppPreferences.SCALE_FACTOR.set(tmp);
                AppPreferences.getPrefs().remove(AppPreferences.SCALE_FACTOR.getIdentifier());
                WindowOptions.this.zoomValue.setValue((int)(tmp * 100.0));
            }
        }
    }
}

