/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.prefs.ColorChooserButton;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitor;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.Projects;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SimOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final MyColorListener mcol = new MyColorListener();
    private final JLabel trueColorTitle = new JLabel();
    private final ColorChooserButton trueColor;
    private final JLabel trueCharTitle = new JLabel();
    private final SymbolChooser trueChar = new SymbolChooser(AppPreferences.TRUE_CHAR, "1T");
    private final JLabel falseColorTitle = new JLabel();
    private final ColorChooserButton falseColor;
    private final JLabel falseCharTitle = new JLabel();
    private final SymbolChooser falseChar = new SymbolChooser(AppPreferences.FALSE_CHAR, "0F");
    private final JLabel unknownColorTitle = new JLabel();
    private final ColorChooserButton unknownColor;
    private final JLabel unknownCharTitle = new JLabel();
    private final SymbolChooser unknownChar = new SymbolChooser(AppPreferences.UNKNOWN_CHAR, "U?Z");
    private final JLabel errorColorTitle = new JLabel();
    private final ColorChooserButton errorColor;
    private final JLabel errorCharTitle = new JLabel();
    private final SymbolChooser errorChar = new SymbolChooser(AppPreferences.ERROR_CHAR, "E!X");
    private final JLabel nilColorTitle = new JLabel();
    private final ColorChooserButton nilColor;
    private final JLabel dontCareCharTitle = new JLabel();
    private final SymbolChooser dontCareChar = new SymbolChooser(AppPreferences.DONTCARE_CHAR, "-X");
    private final JLabel busColorTitle = new JLabel();
    private final ColorChooserButton busColor;
    private final JLabel highlightColorTitle = new JLabel();
    private final ColorChooserButton highlightColor;
    private final JLabel widthErrorColorTitle = new JLabel();
    private final ColorChooserButton widthErrorColor;
    private final JLabel widthErrorCaptionColorTitle = new JLabel();
    private final ColorChooserButton widthErrorCaptionColor;
    private final JLabel widthErrorHighlightColorTitle = new JLabel();
    private final ColorChooserButton widthErrorHighlightColor;
    private final JLabel widthErrorBackgroundColorTitle = new JLabel();
    private final ColorChooserButton clockFrequencyColor;
    private final JLabel clockFrequencyColorTitle = new JLabel();
    private final ColorChooserButton widthErrorBackgroundColor;
    private final JButton defaultButton = new JButton();
    private final JButton colorBlindButton = new JButton();
    private final JLabel kmap1ColorTitle = new JLabel();
    private final JLabel kmap2ColorTitle = new JLabel();
    private final JLabel kmap3ColorTitle = new JLabel();
    private final JLabel kmap4ColorTitle = new JLabel();
    private final JLabel kmap5ColorTitle = new JLabel();
    private final JLabel kmap6ColorTitle = new JLabel();
    private final JLabel kmap7ColorTitle = new JLabel();
    private final JLabel kmap8ColorTitle = new JLabel();
    private final JLabel kmap9ColorTitle = new JLabel();
    private final JLabel kmap10ColorTitle = new JLabel();
    private final JLabel kmap11ColorTitle = new JLabel();
    private final JLabel kmap12ColorTitle = new JLabel();
    private final JLabel kmap13ColorTitle = new JLabel();
    private final JLabel kmap14ColorTitle = new JLabel();
    private final JLabel kmap15ColorTitle = new JLabel();
    private final JLabel kmap16ColorTitle = new JLabel();
    private final JLabel kmapColorsTitle = new JLabel("", 0);
    private final ColorChooserButton kmap1Color;
    private final ColorChooserButton kmap2Color;
    private final ColorChooserButton kmap3Color;
    private final ColorChooserButton kmap4Color;
    private final ColorChooserButton kmap5Color;
    private final ColorChooserButton kmap6Color;
    private final ColorChooserButton kmap7Color;
    private final ColorChooserButton kmap8Color;
    private final ColorChooserButton kmap9Color;
    private final ColorChooserButton kmap10Color;
    private final ColorChooserButton kmap11Color;
    private final ColorChooserButton kmap12Color;
    private final ColorChooserButton kmap13Color;
    private final ColorChooserButton kmap14Color;
    private final ColorChooserButton kmap15Color;
    private final ColorChooserButton kmap16Color;

    public SimOptions(PreferencesFrame window) {
        super(window);
        AppPreferences.getPrefs().addPreferenceChangeListener(new MyListener());
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gbc.insets = new Insets(2, 4, 4, 2);
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.trueColorTitle, gbc);
        ++gbc.gridx;
        this.trueColor = new ColorChooserButton(window, AppPreferences.TRUE_COLOR);
        this.add((Component)this.trueColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.trueCharTitle, gbc);
        ++gbc.gridx;
        this.add((Component)this.trueChar, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.falseColorTitle, gbc);
        ++gbc.gridx;
        this.falseColor = new ColorChooserButton(window, AppPreferences.FALSE_COLOR);
        this.add((Component)this.falseColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.falseCharTitle, gbc);
        ++gbc.gridx;
        this.add((Component)this.falseChar, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.unknownColorTitle, gbc);
        ++gbc.gridx;
        this.unknownColor = new ColorChooserButton(window, AppPreferences.UNKNOWN_COLOR);
        this.add((Component)this.unknownColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.unknownCharTitle, gbc);
        ++gbc.gridx;
        this.add((Component)this.unknownChar, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.errorColorTitle, gbc);
        ++gbc.gridx;
        this.errorColor = new ColorChooserButton(window, AppPreferences.ERROR_COLOR);
        this.add((Component)this.errorColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.errorCharTitle, gbc);
        ++gbc.gridx;
        this.add((Component)this.errorChar, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.nilColorTitle, gbc);
        ++gbc.gridx;
        this.nilColor = new ColorChooserButton(window, AppPreferences.NIL_COLOR);
        this.add((Component)this.nilColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.dontCareCharTitle, gbc);
        ++gbc.gridx;
        this.add((Component)this.dontCareChar, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.busColorTitle, gbc);
        ++gbc.gridx;
        this.busColor = new ColorChooserButton(window, AppPreferences.BUS_COLOR);
        this.add((Component)this.busColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.highlightColorTitle, gbc);
        ++gbc.gridx;
        this.highlightColor = new ColorChooserButton(window, AppPreferences.STROKE_COLOR);
        this.add((Component)this.highlightColor, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.widthErrorColorTitle, gbc);
        ++gbc.gridx;
        this.widthErrorColor = new ColorChooserButton(window, AppPreferences.WIDTH_ERROR_COLOR);
        this.add((Component)this.widthErrorColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.widthErrorCaptionColorTitle, gbc);
        ++gbc.gridx;
        this.widthErrorCaptionColor = new ColorChooserButton(window, AppPreferences.WIDTH_ERROR_CAPTION_COLOR);
        this.add((Component)this.widthErrorCaptionColor, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.widthErrorHighlightColorTitle, gbc);
        ++gbc.gridx;
        this.widthErrorHighlightColor = new ColorChooserButton(window, AppPreferences.WIDTH_ERROR_HIGHLIGHT_COLOR);
        this.add((Component)this.widthErrorHighlightColor, gbc);
        ++gbc.gridx;
        this.add((Component)this.widthErrorBackgroundColorTitle, gbc);
        ++gbc.gridx;
        this.widthErrorBackgroundColor = new ColorChooserButton(window, AppPreferences.WIDTH_ERROR_BACKGROUND_COLOR);
        this.add((Component)this.widthErrorBackgroundColor, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.clockFrequencyColorTitle, gbc);
        ++gbc.gridx;
        this.clockFrequencyColor = new ColorChooserButton(window, AppPreferences.CLOCK_FREQUENCY_COLOR);
        this.add((Component)this.clockFrequencyColor, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.add((Component)this.kmapColorsTitle, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.kmap1ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap1Color = new ColorChooserButton(window, AppPreferences.KMAP1_COLOR);
        this.add((Component)this.kmap1Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap2ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap2Color = new ColorChooserButton(window, AppPreferences.KMAP2_COLOR);
        this.add((Component)this.kmap2Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.kmap3ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap3Color = new ColorChooserButton(window, AppPreferences.KMAP3_COLOR);
        this.add((Component)this.kmap3Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap4ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap4Color = new ColorChooserButton(window, AppPreferences.KMAP4_COLOR);
        this.add((Component)this.kmap4Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.kmap5ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap5Color = new ColorChooserButton(window, AppPreferences.KMAP5_COLOR);
        this.add((Component)this.kmap5Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap6ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap6Color = new ColorChooserButton(window, AppPreferences.KMAP6_COLOR);
        this.add((Component)this.kmap6Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.kmap7ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap7Color = new ColorChooserButton(window, AppPreferences.KMAP7_COLOR);
        this.add((Component)this.kmap7Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap8ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap8Color = new ColorChooserButton(window, AppPreferences.KMAP8_COLOR);
        this.add((Component)this.kmap8Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.kmap9ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap9Color = new ColorChooserButton(window, AppPreferences.KMAP9_COLOR);
        this.add((Component)this.kmap9Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap10ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap10Color = new ColorChooserButton(window, AppPreferences.KMAP10_COLOR);
        this.add((Component)this.kmap10Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.kmap11ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap11Color = new ColorChooserButton(window, AppPreferences.KMAP11_COLOR);
        this.add((Component)this.kmap11Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap12ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap12Color = new ColorChooserButton(window, AppPreferences.KMAP12_COLOR);
        this.add((Component)this.kmap12Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.kmap13ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap13Color = new ColorChooserButton(window, AppPreferences.KMAP13_COLOR);
        this.add((Component)this.kmap13Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap14ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap14Color = new ColorChooserButton(window, AppPreferences.KMAP14_COLOR);
        this.add((Component)this.kmap14Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.kmap15ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap15Color = new ColorChooserButton(window, AppPreferences.KMAP15_COLOR);
        this.add((Component)this.kmap15Color, gbc);
        ++gbc.gridx;
        this.add((Component)this.kmap16ColorTitle, gbc);
        ++gbc.gridx;
        this.kmap16Color = new ColorChooserButton(window, AppPreferences.KMAP16_COLOR);
        this.add((Component)this.kmap16Color, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.defaultButton.setActionCommand("default");
        this.defaultButton.addActionListener(this.mcol);
        this.add((Component)this.defaultButton, gbc);
        gbc.gridx += 2;
        this.colorBlindButton.setActionCommand("colorblind");
        this.colorBlindButton.addActionListener(this.mcol);
        this.add((Component)this.colorBlindButton, gbc);
        this.localeChanged();
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("simHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("simTitle");
    }

    @Override
    public void localeChanged() {
        this.trueColorTitle.setText(Strings.S.get("simTrueColTitle"));
        this.trueCharTitle.setText(Strings.S.get("simTrueCharTitle"));
        this.falseColorTitle.setText(Strings.S.get("simFalseColTitle"));
        this.falseCharTitle.setText(Strings.S.get("simFalseCharTitle"));
        this.unknownColorTitle.setText(Strings.S.get("simUnknownColTitle"));
        this.unknownCharTitle.setText(Strings.S.get("simUnknownCharTitle"));
        this.errorColorTitle.setText(Strings.S.get("simErrorColTitle"));
        this.errorCharTitle.setText(Strings.S.get("simErrorCharTitle"));
        this.nilColorTitle.setText(Strings.S.get("simNilColTitle"));
        this.dontCareCharTitle.setText(Strings.S.get("simDontCareCharTitle"));
        this.busColorTitle.setText(Strings.S.get("simBusColTitle"));
        this.highlightColorTitle.setText(Strings.S.get("simStrokeColTitle"));
        this.widthErrorColorTitle.setText(Strings.S.get("simWidthErrorTitle"));
        this.widthErrorCaptionColorTitle.setText(Strings.S.get("simWidthErrorCaptionTitle"));
        this.widthErrorHighlightColorTitle.setText(Strings.S.get("simWidthErrorHighlightTitle"));
        this.widthErrorBackgroundColorTitle.setText(Strings.S.get("simWidthErrorBackgroundTitle"));
        this.clockFrequencyColorTitle.setText(Strings.S.get("simClockFrequencyTitle"));
        this.defaultButton.setText(Strings.S.get("simDefaultColors"));
        this.colorBlindButton.setText(Strings.S.get("simColorBlindColors"));
        this.kmap1ColorTitle.setText(Strings.S.get("simKmapColors", 1));
        this.kmap2ColorTitle.setText(Strings.S.get("simKmapColors", 2));
        this.kmap3ColorTitle.setText(Strings.S.get("simKmapColors", 3));
        this.kmap4ColorTitle.setText(Strings.S.get("simKmapColors", 4));
        this.kmap5ColorTitle.setText(Strings.S.get("simKmapColors", 5));
        this.kmap6ColorTitle.setText(Strings.S.get("simKmapColors", 6));
        this.kmap7ColorTitle.setText(Strings.S.get("simKmapColors", 7));
        this.kmap8ColorTitle.setText(Strings.S.get("simKmapColors", 8));
        this.kmap9ColorTitle.setText(Strings.S.get("simKmapColors", 9));
        this.kmap10ColorTitle.setText(Strings.S.get("simKmapColors", 10));
        this.kmap11ColorTitle.setText(Strings.S.get("simKmapColors", 11));
        this.kmap12ColorTitle.setText(Strings.S.get("simKmapColors", 12));
        this.kmap13ColorTitle.setText(Strings.S.get("simKmapColors", 13));
        this.kmap14ColorTitle.setText(Strings.S.get("simKmapColors", 14));
        this.kmap15ColorTitle.setText(Strings.S.get("simKmapColors", 15));
        this.kmap16ColorTitle.setText(Strings.S.get("simKmapColors", 16));
        this.kmapColorsTitle.setText(Strings.S.get("simKmapColorsTitle"));
    }

    private void setDefaults() {
        AppPreferences.TRUE_COLOR.set(54016);
        AppPreferences.FALSE_COLOR.set(25856);
        AppPreferences.UNKNOWN_COLOR.set(2631679);
        AppPreferences.ERROR_COLOR.set(0xC10000);
        AppPreferences.NIL_COLOR.set(0x818181);
        AppPreferences.BUS_COLOR.set(1);
        AppPreferences.STROKE_COLOR.set(0xFE00FF);
        AppPreferences.WIDTH_ERROR_COLOR.set(16742912);
        AppPreferences.WIDTH_ERROR_CAPTION_COLOR.set(0x560000);
        AppPreferences.WIDTH_ERROR_HIGHLIGHT_COLOR.set(0xFFFE00);
        AppPreferences.WIDTH_ERROR_BACKGROUND_COLOR.set(16770770);
        AppPreferences.CLOCK_FREQUENCY_COLOR.set(16711860);
        AppPreferences.KMAP1_COLOR.set(0x810000);
        AppPreferences.KMAP2_COLOR.set(15145291);
        AppPreferences.KMAP3_COLOR.set(16432831);
        AppPreferences.KMAP4_COLOR.set(11169321);
        AppPreferences.KMAP5_COLOR.set(16089649);
        AppPreferences.KMAP6_COLOR.set(16766901);
        AppPreferences.KMAP7_COLOR.set(0x818000);
        AppPreferences.KMAP8_COLOR.set(0xFFFF1A);
        AppPreferences.KMAP9_COLOR.set(13825341);
        AppPreferences.KMAP10_COLOR.set(129);
        AppPreferences.KMAP11_COLOR.set(9510581);
        AppPreferences.KMAP12_COLOR.set(3978671);
        AppPreferences.KMAP13_COLOR.set(33484);
        AppPreferences.KMAP14_COLOR.set(15187711);
        AppPreferences.KMAP15_COLOR.set(11206596);
        AppPreferences.KMAP16_COLOR.set(15741671);
        this.repaint();
    }

    private void setColorBlind() {
        AppPreferences.TRUE_COLOR.set(16051010);
        AppPreferences.FALSE_COLOR.set(2112488);
        AppPreferences.UNKNOWN_COLOR.set(113821);
        AppPreferences.ERROR_COLOR.set(0xC10000);
        AppPreferences.NIL_COLOR.set(0x818181);
        AppPreferences.BUS_COLOR.set(1);
        AppPreferences.STROKE_COLOR.set(0xBBBBBB);
        AppPreferences.WIDTH_ERROR_COLOR.set(12850139);
        AppPreferences.WIDTH_ERROR_CAPTION_COLOR.set(0x560000);
        AppPreferences.WIDTH_ERROR_HIGHLIGHT_COLOR.set(0xFFFE00);
        AppPreferences.WIDTH_ERROR_BACKGROUND_COLOR.set(16770770);
        AppPreferences.CLOCK_FREQUENCY_COLOR.set(16711860);
        AppPreferences.KMAP1_COLOR.set(4784274);
        AppPreferences.KMAP2_COLOR.set(0x920000);
        AppPreferences.KMAP3_COLOR.set(18761);
        AppPreferences.KMAP4_COLOR.set(28123);
        AppPreferences.KMAP5_COLOR.set(9586944);
        AppPreferences.KMAP6_COLOR.set(37522);
        AppPreferences.KMAP7_COLOR.set(11955711);
        AppPreferences.KMAP8_COLOR.set(14405888);
        AppPreferences.KMAP9_COLOR.set(16739766);
        AppPreferences.KMAP10_COLOR.set(7190271);
        AppPreferences.KMAP11_COLOR.set(0x24FF24);
        AppPreferences.KMAP12_COLOR.set(16758391);
        AppPreferences.KMAP13_COLOR.set(11983871);
        AppPreferences.KMAP14_COLOR.set(0xFFFF6D);
        AppPreferences.KMAP15_COLOR.set(37522);
        AppPreferences.KMAP16_COLOR.set(16758391);
        this.repaint();
    }

    private class MyColorListener
    implements ActionListener {
        private MyColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("default")) {
                SimOptions.this.setDefaults();
            } else if (e.getActionCommand().equals("colorblind")) {
                SimOptions.this.setColorBlind();
            }
        }
    }

    private static class SymbolChooser
    extends JComboBox<Character> {
        private static final long serialVersionUID = 1L;
        private final PrefMonitor<String> myPref;

        public SymbolChooser(PrefMonitor<String> pref, String choices) {
            this.myPref = pref;
            this.addActionListener(new MyactionListener());
            Character def = Character.valueOf(pref.get().charAt(0));
            int seldef = -1;
            for (int i = 0; i < choices.length(); ++i) {
                Character sel = Character.valueOf(choices.charAt(i));
                if (sel.equals(def)) {
                    seldef = i;
                }
                this.addItem(sel);
            }
            if (seldef >= 0) {
                this.setSelectedIndex(seldef);
            }
        }

        private class MyactionListener
        implements ActionListener {
            private MyactionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox me = (JComboBox)e.getSource();
                Character s = (Character)me.getSelectedItem();
                if (s.charValue() != SymbolChooser.this.myPref.get().charAt(0)) {
                    SymbolChooser.this.myPref.set(Character.toString(s.charValue()));
                }
            }
        }
    }

    private static class MyListener
    implements PreferenceChangeListener {
        private MyListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            boolean update = false;
            String key = evt.getKey();
            if (key.equals(AppPreferences.TRUE_COLOR.getIdentifier())) {
                Value.trueColor = new Color(AppPreferences.TRUE_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.TRUE_CHAR.getIdentifier())) {
                Value.TRUECHAR = AppPreferences.TRUE_CHAR.get().charAt(0);
                update = true;
            } else if (key.equals(AppPreferences.FALSE_COLOR.getIdentifier())) {
                Value.falseColor = new Color(AppPreferences.FALSE_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.FALSE_CHAR.getIdentifier())) {
                Value.FALSECHAR = AppPreferences.FALSE_CHAR.get().charAt(0);
                update = true;
            } else if (key.equals(AppPreferences.UNKNOWN_COLOR.getIdentifier())) {
                Value.unknownColor = new Color(AppPreferences.UNKNOWN_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.UNKNOWN_CHAR.getIdentifier())) {
                Value.UNKNOWNCHAR = AppPreferences.UNKNOWN_CHAR.get().charAt(0);
                update = true;
            } else if (key.equals(AppPreferences.ERROR_COLOR.getIdentifier())) {
                Value.errorColor = new Color(AppPreferences.ERROR_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.ERROR_CHAR.getIdentifier())) {
                Value.ERRORCHAR = AppPreferences.ERROR_CHAR.get().charAt(0);
                update = true;
            } else if (key.equals(AppPreferences.NIL_COLOR.getIdentifier())) {
                Value.nilColor = new Color(AppPreferences.NIL_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.DONTCARE_CHAR.getIdentifier())) {
                Value.DONTCARECHAR = AppPreferences.DONTCARE_CHAR.get().charAt(0);
                update = true;
            } else if (key.equals(AppPreferences.BUS_COLOR.getIdentifier())) {
                Value.multiColor = new Color(AppPreferences.BUS_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.STROKE_COLOR.getIdentifier())) {
                Value.strokeColor = new Color(AppPreferences.STROKE_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.WIDTH_ERROR_COLOR.getIdentifier())) {
                Value.widthErrorColor = new Color(AppPreferences.WIDTH_ERROR_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.WIDTH_ERROR_CAPTION_COLOR.getIdentifier())) {
                Value.widthErrorCaptionColor = new Color(AppPreferences.WIDTH_ERROR_CAPTION_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.WIDTH_ERROR_HIGHLIGHT_COLOR.getIdentifier())) {
                Value.widthErrorHighlightColor = new Color(AppPreferences.WIDTH_ERROR_HIGHLIGHT_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.WIDTH_ERROR_BACKGROUND_COLOR.getIdentifier())) {
                Value.widthErrorCaptionBgcolor = new Color(AppPreferences.WIDTH_ERROR_BACKGROUND_COLOR.get());
                update = true;
            } else if (key.equals(AppPreferences.CLOCK_FREQUENCY_COLOR.getIdentifier())) {
                Value.clockFrequencyColor = new Color(AppPreferences.CLOCK_FREQUENCY_COLOR.get());
                update = true;
            }
            if (update) {
                for (Project proj : Projects.getOpenProjects()) {
                    proj.getFrame().repaint();
                }
            }
        }
    }
}

