/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.opts;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.file.MouseMappings;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.AttrTable;
import com.cburch.logisim.gui.generic.ProjectExplorer;
import com.cburch.logisim.gui.generic.ProjectExplorerToolNode;
import com.cburch.logisim.gui.main.AttrTableToolModel;
import com.cburch.logisim.gui.opts.OptionsActions;
import com.cburch.logisim.gui.opts.OptionsFrame;
import com.cburch.logisim.gui.opts.OptionsPanel;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.InputEventUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class MouseOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final MyListener listener = new MyListener();
    private final MappingsModel model;
    private final ProjectExplorer explorer;
    private final JPanel addArea = new AddArea();
    private final JTable mappings = new JTable();
    private final AttrTable attrTable;
    private final JButton remove = new JButton();
    private Tool curTool = null;

    public MouseOptions(OptionsFrame window) {
        super(window, new GridLayout(1, 3));
        this.explorer = new ProjectExplorer(this.getProject(), true);
        this.explorer.setListener(this.listener);
        this.addArea.addMouseListener(this.listener);
        this.model = new MappingsModel();
        this.mappings.setTableHeader(null);
        this.mappings.setModel(this.model);
        this.mappings.setSelectionMode(0);
        this.mappings.getSelectionModel().addListSelectionListener(this.listener);
        this.mappings.clearSelection();
        JScrollPane mapPane = new JScrollPane(this.mappings);
        JPanel removeArea = new JPanel();
        this.remove.addActionListener(this.listener);
        this.remove.setEnabled(false);
        removeArea.add(this.remove);
        this.attrTable = new AttrTable(this.getOptionsFrame());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gridbag);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 4;
        gbc.fill = 1;
        JScrollPane explorerPane = new JScrollPane(this.explorer, 22, 30);
        gridbag.setConstraints(explorerPane, gbc);
        this.add(explorerPane);
        gbc.weightx = 0.0;
        JPanel gap = new JPanel();
        gap.setPreferredSize(new Dimension(10, 10));
        gridbag.setConstraints(gap, gbc);
        this.add(gap);
        gbc.weightx = 1.0;
        gbc.gridheight = 1;
        gbc.gridx = 2;
        gbc.gridy = -1;
        gbc.weighty = 0.0;
        gridbag.setConstraints(this.addArea, gbc);
        this.add(this.addArea);
        gbc.weighty = 1.0;
        gridbag.setConstraints(mapPane, gbc);
        this.add(mapPane);
        gbc.weighty = 0.0;
        gridbag.setConstraints(removeArea, gbc);
        this.add(removeArea);
        gbc.weighty = 1.0;
        gridbag.setConstraints(this.attrTable, gbc);
        this.add(this.attrTable);
        this.getOptions().getMouseMappings().addMouseMappingsListener(this.listener);
        this.setCurrentTool(null);
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("mouseHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("mouseTitle");
    }

    @Override
    public void localeChanged() {
        this.remove.setText(Strings.S.get("mouseRemoveButton"));
        this.addArea.repaint();
    }

    private void setCurrentTool(Tool t) {
        this.curTool = t;
        this.localeChanged();
    }

    private void setSelectedRow(int row) {
        if (row < 0) {
            row = 0;
        }
        if (row >= this.model.getRowCount()) {
            row = this.model.getRowCount() - 1;
        }
        if (row >= 0) {
            this.mappings.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private class MyListener
    implements ActionListener,
    BaseMouseListenerContract,
    ListSelectionListener,
    MouseMappings.MouseMappingsListener,
    ProjectExplorer.Listener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == MouseOptions.this.remove) {
                int row = MouseOptions.this.mappings.getSelectedRow();
                MouseOptions.this.getProject().doAction(OptionsActions.removeMapping(MouseOptions.this.getOptions().getMouseMappings(), MouseOptions.this.model.getKey(row)));
                row = Math.min(row, MouseOptions.this.model.getRowCount() - 1);
                if (row >= 0) {
                    MouseOptions.this.setSelectedRow(row);
                }
            }
        }

        @Override
        public JPopupMenu menuRequested(ProjectExplorer.Event event) {
            return null;
        }

        @Override
        public void mouseMappingsChanged() {
            MouseOptions.this.model.fireTableStructureChanged();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == MouseOptions.this.addArea && MouseOptions.this.curTool != null) {
                Tool t = MouseOptions.this.curTool.cloneTool();
                Integer mods = e.getModifiersEx();
                MouseOptions.this.getProject().doAction(OptionsActions.setMapping(MouseOptions.this.getOptions().getMouseMappings(), mods, t));
                MouseOptions.this.setSelectedRow(MouseOptions.this.model.getRow(mods));
            }
        }

        @Override
        public void selectionChanged(ProjectExplorer.Event event) {
            Object target = event.getTarget();
            if (target instanceof ProjectExplorerToolNode) {
                ProjectExplorerToolNode toolNode = (ProjectExplorerToolNode)target;
                MouseOptions.this.setCurrentTool((Tool)toolNode.getValue());
            } else {
                MouseOptions.this.setCurrentTool(null);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = MouseOptions.this.mappings.getSelectedRow();
            if (row < 0) {
                MouseOptions.this.remove.setEnabled(false);
                MouseOptions.this.attrTable.setAttrTableModel(null);
            } else {
                MouseOptions.this.remove.setEnabled(true);
                Tool tool = MouseOptions.this.model.getTool(row);
                Project proj = MouseOptions.this.getProject();
                AttrTableToolModel model = tool.getAttributeSet() != null ? new AttrTableToolModel(proj, tool) : null;
                MouseOptions.this.attrTable.setAttrTableModel(model);
            }
        }
    }

    private class AddArea
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public AddArea() {
            this.setPreferredSize(new Dimension(75, 60));
            this.setMinimumSize(new Dimension(75, 60));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createEtchedBorder()));
        }

        @Override
        public void paintComponent(Graphics g) {
            String label2;
            String label1;
            if (AppPreferences.AntiAliassing.getBoolean()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            super.paintComponent(g);
            Dimension sz = this.getSize();
            g.setFont(MouseOptions.this.remove.getFont());
            if (MouseOptions.this.curTool == null) {
                g.setColor(Color.GRAY);
                label1 = Strings.S.get("mouseMapNone");
                label2 = null;
            } else {
                g.setColor(Color.BLACK);
                label1 = Strings.S.get("mouseMapText");
                label2 = Strings.S.get("mouseMapText2", MouseOptions.this.curTool.getDisplayName());
            }
            FontMetrics fm = g.getFontMetrics();
            int x1 = (sz.width - fm.stringWidth(label1)) / 2;
            if (label2 == null) {
                int y = Math.max(0, (sz.height - fm.getHeight()) / 2 + fm.getAscent() - 2);
                g.drawString(label1, x1, y);
            } else {
                int x2 = (sz.width - fm.stringWidth(label2)) / 2;
                int y = Math.max(0, (sz.height - 2 * fm.getHeight()) / 2 + fm.getAscent() - 2);
                g.drawString(label1, x1, y);
                g.drawString(label2, x2, y += fm.getHeight());
            }
        }
    }

    private class MappingsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        ArrayList<Integer> curKeys;

        MappingsModel() {
            this.fireTableStructureChanged();
        }

        @Override
        public void fireTableStructureChanged() {
            this.curKeys = new ArrayList<Integer>(MouseOptions.this.getOptions().getMouseMappings().getMappedModifiers());
            Collections.sort(this.curKeys);
            super.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        Integer getKey(int row) {
            return this.curKeys.get(row);
        }

        int getRow(Integer mods) {
            int row = Collections.binarySearch(this.curKeys, mods);
            if (row < 0) {
                row = -(row + 1);
            }
            return row;
        }

        @Override
        public int getRowCount() {
            return this.curKeys.size();
        }

        Tool getTool(int row) {
            if (row < 0 || row >= this.curKeys.size()) {
                return null;
            }
            return MouseOptions.this.getOptions().getMouseMappings().getToolFor((int)this.curKeys.get(row));
        }

        @Override
        public Object getValueAt(int row, int column) {
            Integer key = this.curKeys.get(row);
            if (column == 0) {
                return InputEventUtil.toDisplayString(key);
            }
            return MouseOptions.this.getOptions().getMouseMappings().getToolFor(key).getDisplayName();
        }
    }
}

