/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitException;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.gui.generic.AttributeSetTableModel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.ToolAttributeAction;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Tool;

public class AttrTableToolModel
extends AttributeSetTableModel {
    final Project proj;
    final Tool tool;

    public AttrTableToolModel(Project proj, Tool tool) {
        super(tool.getAttributeSet());
        if (tool instanceof AddTool) {
            AddTool addTool = (AddTool)tool;
            this.setInstance(addTool.getFactory());
            this.setIsTool();
        }
        this.proj = proj;
        this.tool = tool;
    }

    @Override
    public String getTitle() {
        return this.tool.getDisplayName();
    }

    public Tool getTool() {
        return this.tool;
    }

    @Override
    public void setValueRequested(Attribute<Object> attr, Object value) {
        AddTool addTool;
        ComponentFactory componentFactory;
        Tool tool = this.tool;
        if (tool instanceof AddTool && (componentFactory = (addTool = (AddTool)tool).getFactory()) instanceof SubcircuitFactory) {
            SubcircuitFactory fac = (SubcircuitFactory)componentFactory;
            if (attr.equals(CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE) || attr.equals(CircuitAttributes.NAME_ATTR)) {
                try {
                    CircuitMutation mutation = new CircuitMutation(fac.getSubcircuit());
                    mutation.setForCircuit(attr, value);
                    Action action = mutation.toAction(null);
                    this.proj.doAction(action);
                }
                catch (CircuitException ex) {
                    OptionPane.showMessageDialog(this.proj.getFrame(), ex.getMessage());
                }
                return;
            }
        }
        this.proj.doAction(ToolAttributeAction.create(this.tool, attr, value));
    }
}

