/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ValueTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Font HEAD_FONT = new Font("Serif", 1, 14);
    private static final Font BODY_FONT = new Font("Monospaced", 0, 14);
    private static final int COLUMN_SEP = 8;
    private static final int HEADER_SEP = 4;
    private final TableHeader header = new TableHeader();
    private final TableBody body = new TableBody();
    private final VerticalScrollBar vsb = new VerticalScrollBar();
    private final JScrollPane scrollPane = new JScrollPane(this.body, 22, 30);
    private Cell[][] rowData;
    private int rowStart;
    private int rowCount;
    private int[] columnWidth;
    private int cellHeight;
    private int tableWidth;
    private int tableHeight;
    private Model model;

    public ValueTable(Model model) {
        this.scrollPane.setVerticalScrollBar(this.vsb);
        this.scrollPane.setColumnHeaderView(this.header);
        this.scrollPane.getViewport().setBorder(null);
        Border b = this.scrollPane.getViewportBorder();
        this.scrollPane.setViewportBorder(null);
        this.scrollPane.setBorder(b);
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
        ToolTipManager.sharedInstance().registerComponent(this.header);
        ToolTipManager.sharedInstance().registerComponent(this.body);
        this.setModel(model);
    }

    private void computePreferredSize() {
        int columns;
        int oldCellHeight = this.cellHeight;
        int oldTableWidth = this.tableWidth;
        int oldTableHeight = this.tableHeight;
        int n = columns = this.model == null ? 0 : this.model.getColumnCount();
        if (this.columnWidth == null || this.columnWidth.length < columns) {
            this.columnWidth = new int[columns];
        }
        if (columns == 0) {
            this.cellHeight = 16;
            this.tableHeight = 0;
            this.tableWidth = 0;
        } else {
            Graphics g = this.getGraphics();
            int cellsWidth = 0;
            if (g == null) {
                this.cellHeight = 16;
                cellsWidth = 24 * columns;
            } else {
                FontMetrics headerMetric = g.getFontMetrics(HEAD_FONT);
                FontMetrics bodyMetric = g.getFontMetrics(BODY_FONT);
                this.cellHeight = Math.max(headerMetric.getHeight(), bodyMetric.getHeight());
                for (int i = 0; i < columns; ++i) {
                    int radix = this.model.getColumnValueRadix(i);
                    String header = this.model.getColumnName(i);
                    int cellWidth = Math.max(24, headerMetric.stringWidth(header));
                    BitWidth w = this.model.getColumnValueWidth(i);
                    if (w != null) {
                        Value val = Value.createKnown(w, radix == 2 ? 0L : (radix == 10 ? (long)(1 << w.getWidth() - 1) : w.getMask()));
                        String label = val.toDisplayString(radix);
                        cellWidth = Math.max(cellWidth, bodyMetric.stringWidth(label));
                    }
                    this.columnWidth[i] = cellWidth;
                    cellsWidth += cellWidth;
                }
            }
            this.tableWidth = cellsWidth + 8 * (columns + 1);
            this.tableHeight = this.cellHeight * this.model.getRowCount();
        }
        if (this.cellHeight != oldCellHeight || this.tableWidth != oldTableWidth || this.tableHeight != oldTableHeight) {
            Dimension headSize = new Dimension(this.tableWidth, this.cellHeight + 4);
            Dimension bodySize = new Dimension(this.tableWidth, this.tableHeight);
            this.body.setPreferredSize(bodySize);
            this.header.setPreferredSize(headSize);
            this.body.revalidate();
            this.header.revalidate();
        }
    }

    public void dataChanged() {
        this.rowCount = 0;
        this.repaint();
    }

    int findColumn(int x, int width) {
        int left = Math.max(0, (width - this.tableWidth) / 2);
        if (x < left + 8 || x >= left + this.tableWidth) {
            return -1;
        }
        left += 8;
        int columns = this.model.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            int cellWidth = this.columnWidth[i];
            if (x >= left && x < left + cellWidth) {
                return i;
            }
            left += cellWidth + 8;
        }
        return -1;
    }

    int findRow(int y, int height) {
        if (y < 0) {
            return -1;
        }
        int row = y / this.cellHeight;
        if (row >= this.rowCount) {
            return -1;
        }
        return row;
    }

    public void modelChanged() {
        this.computePreferredSize();
        this.dataChanged();
    }

    void refreshData(int top, int bottom) {
        int columns;
        int n = columns = this.model == null ? 0 : this.model.getColumnCount();
        if (columns == 0) {
            this.rowCount = 0;
            return;
        }
        int rows = this.model.getRowCount();
        if (rows == 0) {
            this.rowCount = 0;
            return;
        }
        int topRow = Math.min(rows - 1, Math.max(0, top / this.cellHeight));
        int bottomRow = Math.min(rows - 1, Math.max(0, bottom / this.cellHeight));
        if (this.rowData != null && this.rowStart <= topRow && topRow < this.rowStart + this.rowCount && this.rowStart <= bottomRow && bottomRow < this.rowStart + this.rowCount) {
            return;
        }
        Rectangle rect = this.scrollPane.getViewport().getViewRect();
        top = rect.y - rect.height / 2;
        bottom = rect.y + rect.height * 2;
        topRow = Math.min(rows - 1, Math.max(0, top / this.cellHeight - 10));
        bottomRow = Math.min(rows - 1, Math.max(0, bottom / this.cellHeight + 10));
        this.rowStart = Math.min(topRow, bottomRow);
        this.rowCount = Math.max(topRow, bottomRow) - this.rowStart + 1;
        if (this.rowCount == 0) {
            return;
        }
        if (this.rowData == null || this.rowData.length < this.rowCount || this.rowData[0].length != columns) {
            this.rowData = new Cell[this.rowCount + 1][columns];
        }
        this.model.getRowData(this.rowStart, this.rowCount, this.rowData);
    }

    public void setModel(Model model) {
        this.model = model;
        this.modelChanged();
    }

    private class TableHeader
    extends JPanel {
        private static final long serialVersionUID = 1L;

        TableHeader() {
            this.addMouseListener(new MyListener());
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int col;
            int n = col = ValueTable.this.model == null ? -1 : ValueTable.this.findColumn(event.getX(), this.getSize().width);
            if (col < 0) {
                return null;
            }
            int radix = ValueTable.this.model.getColumnValueRadix(col);
            if (radix == 0) {
                return null;
            }
            return Strings.S.get("tableHeaderHelp", Integer.toString(radix));
        }

        @Override
        public void paintComponent(Graphics g) {
            int columns;
            super.paintComponent(g);
            Dimension sz = this.getSize();
            g.setColor(Color.GRAY);
            int n = columns = ValueTable.this.model == null ? 0 : ValueTable.this.model.getColumnCount();
            if (columns == 0) {
                g.drawLine(0, ValueTable.this.cellHeight + 2, sz.width, ValueTable.this.cellHeight + 2);
                return;
            }
            g.setFont(HEAD_FONT);
            FontMetrics headerMetric = g.getFontMetrics();
            boolean top = false;
            int left = Math.max(0, (sz.width - ValueTable.this.tableWidth) / 2);
            g.drawLine(left, ValueTable.this.cellHeight + 2, left + ValueTable.this.tableWidth, ValueTable.this.cellHeight + 2);
            int x = left + 8;
            int y = 0 + headerMetric.getAscent() + 1;
            for (int i = 0; i < columns; ++i) {
                g.setColor(Color.GRAY);
                g.drawLine(x - 4, 0, x - 4, ValueTable.this.cellHeight);
                g.setColor(Color.BLACK);
                String label = ValueTable.this.model.getColumnName(i);
                int cellWidth = ValueTable.this.columnWidth[i];
                int width = headerMetric.stringWidth(label);
                g.drawString(label, x + (cellWidth - width) / 2, y);
                x += cellWidth + 8;
            }
            g.setColor(Color.GRAY);
            g.drawLine(x - 4, 0, x - 4, ValueTable.this.cellHeight);
        }

        class MyListener
        extends MouseAdapter {
            MyListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int col;
                int n = col = ValueTable.this.model == null ? -1 : ValueTable.this.findColumn(e.getX(), TableHeader.this.getSize().width);
                if (col >= 0) {
                    ValueTable.this.model.changeColumnValueRadix(col);
                }
            }
        }
    }

    private class TableBody
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private TableBody() {
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int row;
            int col;
            int n = col = ValueTable.this.model == null ? -1 : ValueTable.this.findColumn(event.getX(), this.getSize().width);
            if (col < 0) {
                return null;
            }
            int n2 = row = ValueTable.this.rowData == null ? -1 : ValueTable.this.findRow(event.getY(), this.getSize().height);
            if (ValueTable.this.rowStart > row || row >= ValueTable.this.rowStart + ValueTable.this.rowCount) {
                return null;
            }
            Cell cell = ValueTable.this.rowData[row - ValueTable.this.rowStart][col];
            if (cell == null) {
                return null;
            }
            return cell.tip;
        }

        @Override
        public void paintComponent(Graphics g) {
            int columns;
            super.paintComponent(g);
            Dimension sz = this.getSize();
            g.setColor(Color.BLACK);
            g.setFont(BODY_FONT);
            int n = columns = ValueTable.this.model == null ? 0 : ValueTable.this.model.getColumnCount();
            if (columns == 0) {
                ValueTable.this.rowCount = 0;
                GraphicsUtil.drawCenteredText(g, Strings.S.get("tableEmptyMessage"), sz.width / 2, sz.height / 2);
                return;
            }
            FontMetrics bodyMetric = g.getFontMetrics();
            Rectangle clip = g.getClipBounds();
            ValueTable.this.refreshData(clip.y, clip.y + clip.height);
            if (ValueTable.this.rowCount == 0) {
                return;
            }
            int firstRow = Math.max(0, clip.y / ValueTable.this.cellHeight);
            int lastRow = Math.min(ValueTable.this.model.getRowCount() - 1, (clip.y + clip.height) / ValueTable.this.cellHeight);
            int top = 0;
            int left = Math.max(0, (sz.width - ValueTable.this.tableWidth) / 2);
            int x = left + 8;
            Color bg = this.getBackground();
            for (int col = 0; col < columns; ++col) {
                int y = top + firstRow * ValueTable.this.cellHeight;
                g.setColor(Color.GRAY);
                g.drawLine(x - 4, clip.y, x - 4, clip.y + clip.height);
                g.setColor(Color.BLACK);
                int cellWidth = ValueTable.this.columnWidth[col];
                int radix = ValueTable.this.model.getColumnValueRadix(col);
                for (int row = firstRow; row <= lastRow; ++row) {
                    Cell cell;
                    if (ValueTable.this.rowStart > row || row >= ValueTable.this.rowStart + ValueTable.this.rowCount || (cell = ValueTable.this.rowData[row - ValueTable.this.rowStart][col]) == null) continue;
                    g.setColor(cell.bg == null ? bg : cell.bg);
                    g.fillRect(x - 4 + 1, y, cellWidth + 8 - 1, ValueTable.this.cellHeight);
                    g.setColor(Color.BLACK);
                    if (cell.value != null) {
                        String label = cell.value instanceof Value ? ((Value)cell.value).toDisplayString(radix) : (String)cell.value;
                        int width = bodyMetric.stringWidth(label);
                        if (cell.fg != null) {
                            g.setColor(cell.fg);
                        }
                        g.drawString(label, x + (cellWidth - width) / 2, y + bodyMetric.getAscent());
                        if (cell.fg != null) {
                            g.setColor(Color.BLACK);
                        }
                    }
                    y += ValueTable.this.cellHeight;
                }
                x += cellWidth + 8;
            }
            g.setColor(Color.GRAY);
            g.drawLine(x - 4, clip.y, x - 4, clip.y + clip.height);
        }
    }

    private class VerticalScrollBar
    extends JScrollBar
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private int oldMaximum = -1;
        private int oldExtent = -1;

        public VerticalScrollBar() {
            this.getModel().addChangeListener(this);
        }

        @Override
        public int getBlockIncrement(int direction) {
            int curHeight = this.getVisibleAmount();
            int numCells = curHeight / ValueTable.this.cellHeight - 1;
            if (numCells <= 0) {
                numCells = 1;
            }
            return numCells * ValueTable.this.cellHeight;
        }

        @Override
        public int getUnitIncrement(int direction) {
            return ValueTable.this.cellHeight;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            int newMaximum = this.getMaximum();
            int newExtent = this.getVisibleAmount();
            if (this.oldMaximum != newMaximum || this.oldExtent != newExtent) {
                if (this.getValue() + this.oldExtent >= this.oldMaximum) {
                    this.setValue(newMaximum - newExtent);
                }
                this.oldMaximum = newMaximum;
                this.oldExtent = newExtent;
            }
        }
    }

    public static interface Model {
        public void changeColumnValueRadix(int var1);

        public int getColumnCount();

        public String getColumnName(int var1);

        public int getColumnValueRadix(int var1);

        public BitWidth getColumnValueWidth(int var1);

        public int getRowCount();

        public void getRowData(int var1, int var2, Cell[][] var3);
    }

    public static class Cell {
        public final Object value;
        public final Color bg;
        public final Color fg;
        public final String tip;

        public Cell(Object v, Color b, Color f, String t) {
            this.value = v;
            this.bg = b;
            this.fg = f;
            this.tip = t;
        }
    }
}

