/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.hex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

abstract class BufferedLineReader {
    protected long bufSize;
    protected int bPos;
    protected int charPos;
    protected char[] buf = new char[4096];
    protected int bufCount = 0;
    protected int bufPos = 0;
    private boolean skipNextNewline = false;

    BufferedLineReader() {
    }

    public static BufferedLineReader forString(String s) {
        return new ReaderForString(s);
    }

    public static BufferedLineReader forFile(File filename) throws IOException {
        return new ReaderForFile(filename);
    }

    public void reset() throws IOException {
        this.bPos = 0;
        this.charPos = 0;
        this.bufPos = 0;
        this.bufCount = 0;
        this.skipNextNewline = false;
    }

    public int bytePosition() {
        return this.bPos;
    }

    public int charPosition() {
        return this.charPos;
    }

    public long byteLength() {
        return this.bufSize;
    }

    abstract int underlyingReadUtf8(char[] var1, int var2, int var3) throws IOException;

    abstract int underlyingReadBytes(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;

    public int readBytes(byte[] bbuf, int off, int len) throws IOException {
        int n;
        if (this.buf == null) {
            throw new IOException("stream closed");
        }
        if (len <= 0) {
            return 0;
        }
        if (this.skipNextNewline || this.bufPos < this.bufCount) {
            throw new IOException("raw byte read after unicode I/O");
        }
        int total = this.underlyingReadBytes(bbuf, off, len);
        if (total <= 0) {
            return total;
        }
        this.bPos += total;
        while (total < len && (long)this.bPos < this.bufSize && (n = this.underlyingReadBytes(bbuf, off + total, len - total)) > 0) {
            total += n;
        }
        return total;
    }

    public String readLine() throws IOException {
        if (this.buf == null) {
            throw new IOException("stream closed");
        }
        if (this.bufPos >= this.bufCount && !this.refill()) {
            return null;
        }
        if (this.skipNextNewline && this.buf[this.bufPos] == '\n') {
            ++this.charPos;
            ++this.bufPos;
            if (this.bufPos >= this.bufCount && !this.refill()) {
                return null;
            }
        }
        this.skipNextNewline = false;
        StringBuilder ret = new StringBuilder(100);
        do {
            int initPos = this.bufPos;
            while (this.bufPos < this.bufCount) {
                char c = this.buf[this.bufPos];
                ++this.charPos;
                ++this.bufPos;
                if (c != '\n' && c != '\r') continue;
                this.skipNextNewline = c == '\r';
                ret.append(this.buf, initPos, this.bufPos - initPos - 1);
                return ret.toString();
            }
            ret.append(this.buf, initPos, this.bufPos - initPos);
        } while (this.refill());
        return ret.toString();
    }

    public int readUtf8(char[] cbuf, int off, int len) throws IOException {
        if (this.buf == null) {
            throw new IOException("stream closed");
        }
        if (len <= 0) {
            return 0;
        }
        if (!this.skipNextNewline && this.bufPos >= this.bufCount && len >= this.buf.length) {
            int n = this.underlyingReadUtf8(cbuf, off, len);
            if (n > 0) {
                this.charPos += n;
            }
            return n;
        }
        if (this.bufPos >= this.bufCount && !this.refill()) {
            return -1;
        }
        if (this.skipNextNewline && this.buf[this.bufPos] == '\n') {
            ++this.charPos;
            ++this.bufPos;
            if (this.bufPos >= this.bufCount && !this.refill()) {
                return -1;
            }
        }
        this.skipNextNewline = false;
        int n = Math.min(len, this.bufCount - this.bufPos);
        System.arraycopy(this.buf, this.bufPos, cbuf, off, n);
        this.charPos += n;
        this.bufPos += n;
        return n;
    }

    private boolean refill() throws IOException {
        int n;
        this.bufPos = 0;
        this.bufCount = 0;
        do {
            if ((n = this.underlyingReadUtf8(this.buf, 0, this.buf.length)) >= 0) continue;
            return false;
        } while (n <= 0);
        this.bufPos = 0;
        this.bufCount = n;
        return true;
    }

    private static class ReaderForString
    extends BufferedLineReader {
        StringReader cin;
        ByteArrayInputStream bin;

        public ReaderForString(String s) {
            this.cin = new StringReader(s);
            byte[] b = s.getBytes(StandardCharsets.UTF_8);
            this.bin = new ByteArrayInputStream(b);
            this.bufSize = b.length;
            this.bPos = 0;
            this.charPos = 0;
        }

        @Override
        public void reset() throws IOException {
            this.cin.reset();
            this.bin.reset();
            super.reset();
        }

        @Override
        public void close() throws IOException {
            try {
                this.bin.close();
            }
            finally {
                this.cin = null;
                this.bin = null;
                this.buf = null;
            }
        }

        @Override
        int underlyingReadUtf8(char[] cbuf, int off, int len) throws IOException {
            return this.cin.read(cbuf, off, len);
        }

        @Override
        int underlyingReadBytes(byte[] bbuf, int off, int len) {
            return this.bin.read(bbuf, off, len);
        }
    }

    private static class ReaderForFile
    extends BufferedLineReader {
        RandomAccessFile bin;
        Reader cin;

        ReaderForFile(File f) throws IOException {
            this.bin = new RandomAccessFile(f, "r");
            this.cin = new InputStreamReader((InputStream)new Adapter(this.bin), StandardCharsets.UTF_8);
            this.bufSize = this.bin.length();
            this.bPos = 0;
            this.charPos = 0;
        }

        @Override
        public void reset() throws IOException {
            this.bin.seek(0L);
            this.cin = new InputStreamReader((InputStream)new Adapter(this.bin), StandardCharsets.UTF_8);
            super.reset();
        }

        @Override
        public void close() throws IOException {
            try {
                this.bin.close();
            }
            finally {
                this.bin = null;
                this.cin = null;
                this.buf = null;
            }
        }

        @Override
        int underlyingReadUtf8(char[] cbuf, int off, int len) throws IOException {
            return this.cin.read(cbuf, off, len);
        }

        @Override
        int underlyingReadBytes(byte[] bbuf, int off, int len) throws IOException {
            return this.bin.read(bbuf, off, len);
        }
    }

    private static class Adapter
    extends InputStream {
        final RandomAccessFile randAccessFile;

        Adapter(RandomAccessFile in) {
            this.randAccessFile = in;
        }

        @Override
        public int read() throws IOException {
            return this.randAccessFile.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.randAccessFile.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.randAccessFile.read(b, off, len);
        }
    }
}

