/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.log.LoggableContract;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.std.memory.Register;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RegTabContent
extends JScrollPane
implements LocaleListener,
Simulator.Listener,
ProjectListener,
CircuitListener {
    private final JPanel panel = new JPanel(new GridBagLayout());
    private final GridBagConstraints gridConstraints = new GridBagConstraints();
    private final Project proj;
    private final MyLabel hdrName = new MyLabel("", 3, false, Color.LIGHT_GRAY);
    private final MyLabel hdrValue = new MyLabel("", 1, false, Color.LIGHT_GRAY);
    private boolean showing = false;
    private CircuitState circuitState;
    private final ArrayList<Circuit> circuits = new ArrayList();
    private final ArrayList<Watcher> buildWatchers = new ArrayList();
    private final CopyOnWriteArrayList<Watcher> watchers = new CopyOnWriteArrayList();

    public RegTabContent(Frame frame) {
        this.setViewportView(this.panel);
        this.proj = frame.getProject();
        this.getVerticalScrollBar().setUnitIncrement(16);
        this.gridConstraints.fill = 2;
        this.gridConstraints.anchor = 23;
        this.gridConstraints.ipady = 2;
        this.localeChanged();
        LocaleManager.addLocaleListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                RegTabContent.this.showing = true;
                RegTabContent.this.fill();
                RegTabContent.this.proj.getSimulator().addSimulatorListener(RegTabContent.this);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                RegTabContent.this.showing = false;
                RegTabContent.this.proj.getSimulator().removeSimulatorListener(RegTabContent.this);
            }
        });
        this.proj.addProjectListener(this);
        this.clear();
        this.circuitState = this.proj.getCircuitState();
        this.fill();
    }

    @Override
    public void projectChanged(ProjectEvent event) {
        if (event.getAction() == 4) {
            this.clear();
            this.circuitState = this.proj.getCircuitState();
            this.fill();
        }
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        if (this.circuitState != null && event.getAction() != 4) {
            this.clear();
            this.fill();
        }
    }

    private void clear() {
        if (this.circuits.isEmpty()) {
            return;
        }
        for (Circuit circ : this.circuits) {
            circ.removeCircuitListener(this);
        }
        this.circuits.clear();
        this.watchers.clear();
        this.panel.removeAll();
        this.gridConstraints.weighty = 0.0;
        this.gridConstraints.gridy = 0;
        this.gridConstraints.gridx = 0;
        this.gridConstraints.weightx = 0.7;
        this.panel.add((Component)this.hdrName, this.gridConstraints);
        this.gridConstraints.gridx = 1;
        this.gridConstraints.weightx = 0.3;
        this.panel.add((Component)this.hdrValue, this.gridConstraints);
        this.panel.repaint();
    }

    private void fill() {
        if (!this.showing || this.circuitState == null) {
            return;
        }
        if (this.circuits.isEmpty()) {
            this.enumerate();
            this.watchers.addAll(this.buildWatchers);
            this.buildWatchers.clear();
        }
        this.updateWatchers();
        this.writeValuesToLabels();
    }

    private void updateWatchers() {
        for (Watcher watcher : this.watchers) {
            watcher.update();
        }
    }

    public void writeValuesToLabels() {
        if (!this.showing || this.circuitState == null) {
            return;
        }
        for (Watcher watcher : this.watchers) {
            watcher.writeToLabel();
        }
    }

    private void enumerate() {
        if (this.circuitState == null) {
            return;
        }
        Circuit circ = this.circuitState.getCircuit();
        this.enumerate(null, circ, this.circuitState);
        this.gridConstraints.weighty = 1.0;
        ++this.gridConstraints.gridy;
        this.gridConstraints.gridx = 0;
        this.gridConstraints.weightx = 1.0;
        this.panel.add((Component)new MyLabel("", 0, false, null), this.gridConstraints);
        this.panel.validate();
    }

    private void enumerate(String prefix, Circuit circ, CircuitState cs) {
        if (!this.circuits.contains(circ)) {
            this.circuits.add(circ);
            circ.addCircuitListener(this);
        }
        this.enumerateLoggables(prefix, circ, cs);
        this.enumerateSubcircuits(prefix, circ, cs);
    }

    private void enumerateLoggables(String prefix, Circuit circ, CircuitState cs) {
        HashMap<com.cburch.logisim.comp.Component, String> names = new HashMap<com.cburch.logisim.comp.Component, String>();
        for (com.cburch.logisim.comp.Component comp : circ.getNonWires()) {
            LoggableContract log;
            AttributeSet as = comp.getAttributeSet();
            if (!as.containsAttribute(Register.ATTR_SHOW_IN_TAB) || !as.getValue(Register.ATTR_SHOW_IN_TAB).booleanValue() || (log = (LoggableContract)comp.getFeature(LoggableContract.class)) == null) continue;
            Object name = log.getLogName(null);
            if (name == null) {
                name = comp.getFactory().getName() + String.valueOf(comp.getLocation());
            }
            names.put(comp, (String)name);
        }
        if (names.isEmpty()) {
            return;
        }
        Object[] comps = names.keySet().toArray();
        Arrays.sort(comps, new CompareByNameLocEtc(names));
        for (Object obj : comps) {
            com.cburch.logisim.comp.Component comp = (com.cburch.logisim.comp.Component)obj;
            Object name = names.get(comp);
            if (prefix != null) {
                name = prefix + "/" + (String)name;
            }
            LoggableContract log = (LoggableContract)comp.getFeature(LoggableContract.class);
            ++this.gridConstraints.gridy;
            this.gridConstraints.gridx = 0;
            this.panel.add((Component)new MyLabel((String)name, 2, true, null), this.gridConstraints);
            this.gridConstraints.gridx = 1;
            MyLabel label = new MyLabel("-", 0, false, null);
            this.panel.add((Component)label, this.gridConstraints);
            this.buildWatchers.add(new Watcher(log, cs, label));
        }
    }

    private void enumerateSubcircuits(String prefix, Circuit circ, CircuitState cs) {
        HashMap<com.cburch.logisim.comp.Component, String> names = new HashMap<com.cburch.logisim.comp.Component, String>();
        for (com.cburch.logisim.comp.Component comp : circ.getNonWires()) {
            if (!(comp.getFactory() instanceof SubcircuitFactory)) continue;
            SubcircuitFactory factory = (SubcircuitFactory)comp.getFactory();
            Object name = comp.getAttributeSet().getValue(StdAttr.LABEL);
            if (name == null || ((String)name).equals("")) {
                name = factory.getSubcircuit().getName() + String.valueOf(comp.getLocation());
            }
            names.put(comp, (String)name);
        }
        if (names.isEmpty()) {
            return;
        }
        Object[] comps = names.keySet().toArray();
        Arrays.sort(comps, new CompareByNameLocEtc(names));
        for (Object obj : comps) {
            com.cburch.logisim.comp.Component comp = (com.cburch.logisim.comp.Component)obj;
            Object name = names.get(comp);
            if (prefix != null) {
                name = prefix + "/" + (String)name;
            }
            SubcircuitFactory factory = (SubcircuitFactory)comp.getFactory();
            CircuitState substate = factory.getSubstate(cs, comp);
            this.enumerate((String)name, factory.getSubcircuit(), substate);
        }
    }

    @Override
    public void localeChanged() {
        this.hdrName.setText(Strings.S.get("registerTabNameTitle"));
        this.hdrValue.setText(Strings.S.get("registerTabValueTitle"));
    }

    @Override
    public void simulatorReset(Simulator.Event e) {
        this.updateWatchers();
    }

    @Override
    public void propagationCompleted(Simulator.Event e) {
        this.updateWatchers();
    }

    @Override
    public void simulatorStateChanged(Simulator.Event e) {
    }

    private static class MyLabel
    extends JLabel {
        private MyLabel(String text, int style, boolean small, Color bgColor) {
            super(text);
            if (bgColor != null) {
                this.setOpaque(true);
                this.setBackground(bgColor);
                this.setBorder(BorderFactory.createMatteBorder(0, 4, 0, 4, bgColor));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            }
            if (style == 0 && !small) {
                return;
            }
            Font font = this.getFont();
            if (style != 0) {
                font = font.deriveFont(style);
            }
            if (small) {
                font = font.deriveFont(font.getSize2D() - 2.0f);
            }
            this.setFont(font);
        }
    }

    private static class Watcher {
        final LoggableContract log;
        final CircuitState cs;
        final MyLabel label;
        Value val;

        Watcher(LoggableContract log, CircuitState cs, MyLabel label) {
            this.log = log;
            this.cs = cs;
            this.label = label;
            this.update();
        }

        void update() {
            Value newVal = this.log.getLogValue(this.cs, null);
            if (this.val == null && newVal == null || this.val != null && newVal != null && this.val.equals(newVal)) {
                return;
            }
            this.val = newVal;
        }

        void writeToLabel() {
            this.label.setText(this.val == null ? "-" : this.val.toHexString());
        }
    }

    private static class CompareByNameLocEtc
    implements Comparator<Object> {
        HashMap<com.cburch.logisim.comp.Component, String> names;

        CompareByNameLocEtc(HashMap<com.cburch.logisim.comp.Component, String> names) {
            this.names = names;
        }

        @Override
        public int compare(Object left, Object right) {
            String rightName;
            String leftName = this.names.get((com.cburch.logisim.comp.Component)left);
            int ret = leftName.compareToIgnoreCase(rightName = this.names.get((com.cburch.logisim.comp.Component)right));
            if (ret == 0) {
                ret = ((com.cburch.logisim.comp.Component)left).getLocation().compareTo(((com.cburch.logisim.comp.Component)right).getLocation());
            }
            if (ret == 0) {
                ret = left.hashCode() - right.hashCode();
            }
            return ret;
        }
    }
}

