/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.gui.AttrTableDrawManager;
import com.cburch.draw.toolbar.ToolbarModel;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.draw.tools.SelectTool;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.appear.AppearanceEditHandler;
import com.cburch.logisim.gui.appear.AppearanceToolbarModel;
import com.cburch.logisim.gui.appear.ShowStateTool;
import com.cburch.logisim.gui.generic.AttrTable;
import com.cburch.logisim.gui.generic.BasicZoomModel;
import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.gui.generic.ZoomModel;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class AppearanceView {
    private static final ArrayList<Double> ZOOM_OPTIONS = new ArrayList<Double>(){
        {
            this.add(100.0);
            this.add(150.0);
            this.add(200.0);
            this.add(300.0);
            this.add(400.0);
            this.add(600.0);
            this.add(800.0);
        }
    };
    private final DrawingAttributeSet attrs = new DrawingAttributeSet();
    private final AppearanceCanvas canvas;
    private final CanvasPane canvasPane;
    private final AppearanceToolbarModel toolbarModel;
    private final ZoomModel zoomModel;
    private final AppearanceEditHandler editHandler;
    private AttrTableDrawManager attrTableManager;

    public AppearanceView() {
        SelectTool selectTool = new SelectTool();
        this.canvas = new AppearanceCanvas(selectTool);
        this.canvasPane = new CanvasPane(this.canvas);
        ShowStateTool ssTool = new ShowStateTool(this, this.canvas, this.attrs);
        this.toolbarModel = new AppearanceToolbarModel(selectTool, ssTool, this.canvas, this.attrs);
        this.zoomModel = new BasicZoomModel(AppPreferences.APPEARANCE_SHOW_GRID, AppPreferences.APPEARANCE_ZOOM, ZOOM_OPTIONS, this.canvasPane);
        this.canvas.getGridPainter().setZoomModel(this.zoomModel);
        this.attrTableManager = null;
        this.canvasPane.setZoomModel(this.zoomModel);
        this.editHandler = new AppearanceEditHandler(this.canvas);
    }

    public JFrame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.canvasPane);
    }

    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    public AttrTableDrawManager getAttrTableDrawManager(AttrTable table) {
        AttrTableDrawManager ret = this.attrTableManager;
        if (ret == null) {
            this.attrTableManager = ret = new AttrTableDrawManager(this.canvas, table, this.attrs);
        }
        return ret;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public CanvasPane getCanvasPane() {
        return this.canvasPane;
    }

    public EditHandler getEditHandler() {
        return this.editHandler;
    }

    public ToolbarModel getToolbarModel() {
        return this.toolbarModel;
    }

    public ZoomModel getZoomModel() {
        return this.zoomModel;
    }

    public void setCircuit(Project proj, CircuitState circuitState) {
        this.canvas.setCircuit(proj, circuitState);
    }
}

