/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.Net;
import java.util.ArrayList;
import java.util.List;

public class ClockTreeContainer {
    private final ArrayList<ConnectionPoint> clockSources = new ArrayList();
    private final ArrayList<ConnectionPoint> clockNets = new ArrayList();
    private final int clockSourceId;
    private final ArrayList<String> hierarchyId;
    private boolean isPinClockSource;

    public ClockTreeContainer(List<String> hierarchy, int sourceId, boolean pinClockSource) {
        this.clockSourceId = sourceId;
        this.hierarchyId = new ArrayList();
        this.hierarchyId.addAll(hierarchy);
        this.isPinClockSource = pinClockSource;
    }

    public void addNet(ConnectionPoint netInfo) {
        this.clockNets.add(netInfo);
    }

    public void addSource(ConnectionPoint netInfo) {
        this.clockSources.add(netInfo);
    }

    public void clear() {
        this.clockSources.clear();
        this.clockNets.clear();
    }

    public void setPinClock() {
        this.isPinClockSource = true;
    }

    public boolean isPinClockSource() {
        return this.isPinClockSource;
    }

    public boolean equals(List<String> hierarchy, int sourceId) {
        return sourceId == this.clockSourceId && this.hierarchyId.equals(hierarchy);
    }

    public List<Byte> getClockEntries(Net netInfo) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (ConnectionPoint solderPoint : this.clockSources) {
            if (!solderPoint.getParentNet().equals(netInfo)) continue;
            result.add(solderPoint.getParentNetBitIndex());
        }
        for (ConnectionPoint solderPoint : this.clockNets) {
            if (!solderPoint.getParentNet().equals(netInfo)) continue;
            result.add(solderPoint.getParentNetBitIndex());
        }
        return result;
    }

    public boolean netContainsClockConnection(Net netInfo) {
        for (ConnectionPoint solderPoint : this.clockSources) {
            if (!solderPoint.getParentNet().equals(netInfo)) continue;
            return true;
        }
        for (ConnectionPoint solderPoint : this.clockNets) {
            if (!solderPoint.getParentNet().equals(netInfo)) continue;
            return true;
        }
        return false;
    }

    public boolean netContainsClockSource(Net netInfo) {
        for (ConnectionPoint solderPoint : this.clockSources) {
            if (!solderPoint.getParentNet().equals(netInfo)) continue;
            return true;
        }
        return false;
    }
}

