/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Rectangle;
import com.cburch.draw.shapes.Text;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.DefaultAppearance;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultHolyCrossAppearance {
    public static final int OFFS = 50;
    public static final int LABEL_OUTSIDE = 5;
    public static final int LABEL_GAP = 15;
    public static final int PORT_GAP = 10;
    public static final int TOP_MARGIN = 30;
    public static final int TOP_TEXT_MARGIN = 5;
    public static final int BOTTOM_MARGIN = 5;
    public static final int MIN_WIDTH = 100;
    public static final int MIN_HEIGHT = 40;
    private static final int[] asciiWidths = new int[]{3, 4, 5, 8, 6, 10, 9, 3, 4, 4, 5, 8, 3, 4, 3, 3, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 8, 8, 8, 5, 11, 7, 7, 8, 8, 7, 6, 8, 8, 3, 3, 7, 6, 9, 8, 8, 7, 8, 7, 7, 5, 8, 7, 9, 6, 7, 6, 4, 3, 4, 8, 5, 5, 6, 6, 5, 6, 6, 4, 6, 6, 2, 2, 5, 2, 10, 6, 6, 6, 6, 4, 5, 4, 6, 6, 8, 6, 6, 5, 6, 3, 6};

    public static void calculateTextDimensions(float fontsize) {
        Text label = new Text(0, 0, "a");
        Font f = label.getLabel().getFont().deriveFont(fontsize);
        Canvas canvas = new Canvas();
        FontMetrics fm = canvas.getFontMetrics(f);
        System.out.println("private static int[] asciiWidths = {");
        for (char row = ' '; row <= '~'; row = (char)(row + 8)) {
            StringBuilder comment = new StringBuilder("//");
            StringBuilder chars = new StringBuilder("    ");
            for (char c = row; c < row + 8; c = (char)(c + 1)) {
                if (c >= '~') {
                    chars.append("    ");
                    continue;
                }
                comment.append(String.format(" '%c',", Character.valueOf(c)));
                int w = fm.stringWidth("" + c);
                chars.append(String.format(" %2d,", w));
            }
            System.out.println(String.valueOf(chars) + "  " + String.valueOf(comment));
        }
        System.out.println("};");
        System.exit(0);
    }

    private static int textWidth(String s) {
        int w = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~') {
                w += asciiWidths[c - 32];
                continue;
            }
            w += 8;
        }
        return w;
    }

    public static List<CanvasObject> build(Collection<Instance> pins, String name) {
        int aY;
        int aX;
        HashMap edge = new HashMap();
        edge.put(Direction.EAST, new ArrayList());
        edge.put(Direction.WEST, new ArrayList());
        int maxLeftLabelLength = 0;
        int maxRightLabelLength = 0;
        for (Instance instance : pins) {
            Direction pinEdge;
            String labelString = instance.getAttributeValue(StdAttr.LABEL);
            int labelWidth = DefaultHolyCrossAppearance.textWidth(labelString);
            if (instance.getAttributeValue(Pin.ATTR_TYPE) == Pin.OUTPUT) {
                pinEdge = Direction.EAST;
                if (labelWidth > maxRightLabelLength) {
                    maxRightLabelLength = labelWidth;
                }
            } else {
                pinEdge = Direction.WEST;
                if (labelWidth > maxLeftLabelLength) {
                    maxLeftLabelLength = labelWidth;
                }
            }
            List e = (List)edge.get(pinEdge);
            e.add(instance);
        }
        for (Map.Entry entry : edge.entrySet()) {
            DefaultAppearance.sortPinList((List)entry.getValue(), (Direction)entry.getKey());
        }
        int numEast = ((List)edge.get(Direction.EAST)).size();
        int n = ((List)edge.get(Direction.WEST)).size();
        int maxHorz = Math.max(numEast, n);
        int offsEast = DefaultHolyCrossAppearance.computeOffset(numEast, n);
        int offsWest = DefaultHolyCrossAppearance.computeOffset(n, numEast);
        int width = 10 + maxLeftLabelLength + maxRightLabelLength + 15;
        width = Math.max(100, (width + 9) / 10 * 10);
        int height = 10 * maxHorz + 30 + 5;
        height = Math.max(40, height);
        if (numEast > 0) {
            aX = width;
            aY = offsEast;
        } else if (n > 0) {
            aX = 0;
            aY = offsWest;
        } else {
            aX = 0;
            aY = 0;
        }
        int rx = 50 + (9 - (aX + 9) % 10);
        int ry = 50 + (9 - (aY + 9) % 10);
        Rectangle rect = new Rectangle(rx, ry, width, height);
        rect.setValue(DrawAttr.STROKE_WIDTH, 2);
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>();
        ret.add(rect);
        DefaultHolyCrossAppearance.placePins(ret, (List)edge.get(Direction.WEST), rx, ry + offsWest, 0, 10, true);
        DefaultHolyCrossAppearance.placePins(ret, (List)edge.get(Direction.EAST), rx + width, ry + offsEast, 0, 10, false);
        if (name != null && name.length() > 0) {
            Text label = new Text(rx + width / 2, ry + 5, name);
            label.getLabel().setHorizontalAlignment(0);
            label.getLabel().setVerticalAlignment(8);
            label.getLabel().setColor(Color.BLACK);
            ret.add(label);
        }
        ret.add(new AppearanceAnchor(Location.create(rx + aX, ry + aY, true)));
        return ret;
    }

    private static int computeOffset(int numFacing, int numOpposite) {
        return 30;
    }

    private static void placePins(List<CanvasObject> dest, List<Instance> pins, int x, int y, int dx, int dy, boolean isLeftSide) {
        Color color = Color.DARK_GRAY;
        for (Instance pin : pins) {
            String text;
            int hAlign;
            int ldx;
            dest.add(new AppearancePort(Location.create(x, y, true), pin));
            if (isLeftSide) {
                ldx = 5;
                hAlign = 2;
            } else {
                ldx = -5;
                hAlign = 4;
            }
            if (pin.getAttributeSet().containsAttribute(StdAttr.LABEL) && (text = pin.getAttributeValue(StdAttr.LABEL)) != null && text.length() > 0) {
                Text label = new Text(x + ldx, y, text);
                label.getLabel().setHorizontalAlignment(hAlign);
                label.getLabel().setVerticalAlignment(9);
                label.getLabel().setColor(color);
                Font pinFont = label.getLabel().getFont().deriveFont(10.0f);
                label.getLabel().setFont(pinFont);
                dest.add(label);
            }
            x += dx;
            y += dy;
        }
    }

    private DefaultHolyCrossAppearance() {
    }
}

