/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitChange;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

class CircuitMutatorImpl
implements CircuitMutator {
    private final ArrayList<CircuitChange> log = new ArrayList();
    private final HashMap<Circuit, ReplacementMap> replacements = new HashMap();
    private final HashSet<Circuit> modified = new HashSet();

    @Override
    public void add(Circuit circuit, Component comp) {
        this.modified.add(circuit);
        this.log.add(CircuitChange.add(circuit, comp));
        ReplacementMap repl = new ReplacementMap();
        repl.add(comp);
        this.getMap(circuit).append(repl);
        circuit.mutatorAdd(comp);
    }

    @Override
    public void clear(Circuit circuit) {
        HashSet<Component> comps = new HashSet<Component>(circuit.getNonWires());
        comps.addAll(circuit.getWires());
        if (!comps.isEmpty()) {
            this.modified.add(circuit);
        }
        this.log.add(CircuitChange.clear(circuit, comps));
        ReplacementMap repl = new ReplacementMap();
        for (Component comp : comps) {
            repl.remove(comp);
        }
        this.getMap(circuit).append(repl);
        circuit.mutatorClear();
    }

    private ReplacementMap getMap(Circuit circuit) {
        ReplacementMap ret = this.replacements.get(circuit);
        if (ret == null) {
            ret = new ReplacementMap();
            this.replacements.put(circuit, ret);
        }
        return ret;
    }

    Collection<Circuit> getModifiedCircuits() {
        return Collections.unmodifiableSet(this.modified);
    }

    ReplacementMap getReplacementMap(Circuit circuit) {
        return this.replacements.get(circuit);
    }

    CircuitTransaction getReverseTransaction() {
        CircuitMutation ret = new CircuitMutation();
        ArrayList<CircuitChange> log = this.log;
        for (int i = log.size() - 1; i >= 0; --i) {
            ret.change(log.get(i).getReverseChange());
        }
        return ret;
    }

    void markModified(Circuit circuit) {
        this.modified.add(circuit);
    }

    @Override
    public void remove(Circuit circuit, Component comp) {
        if (circuit.contains(comp)) {
            this.modified.add(circuit);
            this.log.add(CircuitChange.remove(circuit, comp));
            ReplacementMap repl = new ReplacementMap();
            repl.remove(comp);
            this.getMap(circuit).append(repl);
            circuit.mutatorRemove(comp);
        }
    }

    @Override
    public void replace(Circuit circuit, Component prev, Component next) {
        this.replace(circuit, new ReplacementMap(prev, next));
    }

    @Override
    public void replace(Circuit circuit, ReplacementMap repl) {
        if (!repl.isEmpty()) {
            this.modified.add(circuit);
            this.log.add(CircuitChange.replace(circuit, repl));
            repl.freeze();
            this.getMap(circuit).append(repl);
            for (Component component : repl.getRemovals()) {
                circuit.mutatorRemove(component);
            }
            for (Component component : repl.getAdditions()) {
                circuit.mutatorAdd(component);
            }
        }
    }

    @Override
    public void set(Circuit circuit, Component comp, Attribute<?> attr, Object newValue) {
        if (circuit.contains(comp)) {
            this.modified.add(circuit);
            Attribute<?> a = attr;
            AttributeSet attrs = comp.getAttributeSet();
            Object oldValue = attrs.getValue(a);
            this.log.add(CircuitChange.set(circuit, comp, attr, oldValue, newValue));
            attrs.setValue(a, newValue);
        }
    }

    @Override
    public void setForCircuit(Circuit circuit, Attribute<?> attr, Object newValue) {
        Attribute<?> a = attr;
        AttributeSet attrs = circuit.getStaticAttributes();
        Object oldValue = attrs.getValue(a);
        this.log.add(CircuitChange.setForCircuit(circuit, attr, oldValue, newValue));
        attrs.setValue(a, newValue);
        if (attr == CircuitAttributes.NAME_ATTR || attr == CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE) {
            circuit.getAppearance().recomputeDefaultAppearance();
        }
    }
}

